/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.receipt.common.model.receipt.EBConfig;

@Component
public class EBConfigRepository {
    private static final String DETAILINFO_ENTITY = "aqap_bank_login_config";
    private static final String SELECT_ALL_PROPERTIES = "id,config_type,bank_version_id,bank_config_id,bank_config_value,number,custom_id";

    public List<EBConfig> findReceiptConfigByBankVersionIDAndBankLoginIdAndCustomId(String bankVersionID, String bankLoginID, String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<EBConfig> ebConfigArrayList = new ArrayList<EBConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and number=? and bank_version_id=? and config_type=?", (Object[])new Object[]{customId, bankLoginID, bankVersionID, "receipt"});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            EBConfig ebConfig = this.parse(dynamicObject);
            ebConfigArrayList.add(ebConfig);
        }
        return ebConfigArrayList;
    }

    public List<EBConfig> findEGBConfigByBankVersionIDAndBankLoginIdAndCustomId(String bankVersionID, String bankLoginID, String customId) {
        DynamicObject[] dynamicObjects;
        ArrayList<EBConfig> ebConfigArrayList = new ArrayList<EBConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and number=? and bank_version_id=? and config_type=?", (Object[])new Object[]{customId, bankLoginID, bankVersionID, "ebg"});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            EBConfig ebConfig = this.parse(dynamicObject);
            ebConfigArrayList.add(ebConfig);
        }
        return ebConfigArrayList;
    }

    private EBConfig parse(DynamicObject dynamicObject) {
        EBConfig info = new EBConfig();
        info.setId(dynamicObject.getLong("id"));
        info.setBankLoginID(dynamicObject.getString("number"));
        info.setBankVersionID(dynamicObject.getString("bank_version_id"));
        info.setConfigType(dynamicObject.getString("config_type"));
        info.setCustomID(dynamicObject.getString("custom_id"));
        info.setFieldName(dynamicObject.getString("bank_config_id"));
        info.setFieldValue(dynamicObject.getString("bank_config_value"));
        return info;
    }

    public List<EBConfig> findReceiptConfigByConfigIdAndValue(String customId, String configId, String configValue) {
        DynamicObject[] dynamicObjects;
        ArrayList<EBConfig> ebConfigArrayList = new ArrayList<EBConfig>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_config_id=? and bank_config_value=? and config_type=?", (Object[])new Object[]{customId, configId, configValue, "receipt"});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            EBConfig ebConfig = this.parse(dynamicObject);
            ebConfigArrayList.add(ebConfig);
        }
        return ebConfigArrayList;
    }

    public EBConfig findOneByBankAndLoginAndCustomAndConfigId(String bankVersionID, String bankLoginID, String customId, String configId) {
        QFilter filter = QFilter.of((String)"custom_id=? and number=? and bank_version_id=? and config_type=? and bank_config_id = ? ", (Object[])new Object[]{customId, bankLoginID, bankVersionID, "receipt", configId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            EBConfig ebConfig = this.parse(dynamicObject);
            return ebConfig;
        }
        return null;
    }
}

