/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;

@Component
public class ReceiptDownloadTaskRepository {
    private static final String ENTITY_NAME = "receipt_download_task";
    private static final String SELECT_ALL_PROPERTIES = "id,bank_login.number,acc_no.number,bank_version.number,batch_no,trans_date,status,complete_time,exp_msg,redo,receipt_num,detail_num,custom_id,todays_flag,modifytime,createtime,match_num,upload_num,upload_flag,detail_flag,defect_type,suggestion,zip_names,zip_names_tag,file_num,sort";

    public DynamicObjectCollection selectByBankVersionAndAccnoAndTransDateBetween(String bankVersion, String accno, Date transStartDate, Date transEndDate) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_NAME, (String)"acc_no, trans_date, bank_login, bank_version", (QFilter[])new QFilter[]{new QFilter("bank_version.number", "=", (Object)bankVersion), new QFilter("acc_no.number", "=", (Object)accno), new QFilter("trans_date", ">=", (Object)transStartDate), new QFilter("trans_date", "<=", (Object)transEndDate)});
        return dynamicObjectCollection;
    }

    public DynamicObject selectById(Long id) {
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"acc_no, trans_date, bank_login, bank_version,bank_login.number,custom_id, status, redo, exp_msg, complete_time, upload_flag,detail_flag,defect_type,zip_names,zip_names_tag,file_num", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public DynamicObject[] findByComplexCondition(String accNo, String bankVersionID, String bankLoginID, LocalDate startDate, LocalDate endDate, Integer status, String customId) {
        QFilter filter;
        DynamicObjectCollection collection;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)accNo)) {
            expression.append("and acc_no.number=?").append(' ');
            paramsList.add(accNo);
        }
        if (StringUtils.isNotEmpty((String)bankVersionID)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersionID);
        }
        if (StringUtils.isNotEmpty((String)bankLoginID)) {
            expression.append("and bank_login.number=?").append(' ');
            paramsList.add(bankLoginID);
        }
        if (startDate == null && endDate != null || startDate != null && endDate == null) {
            expression.append("and trans_date=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)startDate));
        } else {
            if (startDate != null) {
                expression.append("and trans_date>=?").append(' ');
                paramsList.add(LocalDateUtil.localDate2Date((LocalDate)startDate));
            }
            if (endDate != null) {
                expression.append("and trans_date<=?").append(' ');
                paramsList.add(LocalDateUtil.localDate2Date((LocalDate)endDate));
            }
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (status != null) {
            expression.append("and status=?").append(' ');
            paramsList.add(status.toString());
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        if ((collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())) != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findByBankVersionIDAndTransDateAndCustomId(String bankVersionID, LocalDate transDate, String customId) {
        return this.findByComplexCondition(null, bankVersionID, null, transDate, transDate, null, customId);
    }

    public DynamicObject[] findByStatus(Integer status) {
        return this.findByComplexCondition(null, null, null, null, null, status, null);
    }

    public DynamicObject[] findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        return this.findByComplexCondition(accNo, bankVersionID, null, startDate, endDate, null, null);
    }

    public DynamicObject[] findByAccNoAndCoustomIdAndStatusList(String accNo, String customId, List<Integer> statusArray) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)accNo)) {
            expression.append("and acc_no.number=?").append(' ');
            paramsList.add(accNo);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findTodayByCoustomIdAndStatusListAndBankVersionAndTransDate(String customId, List<Integer> statusArray, String bankVersion, LocalDate transDate) {
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (transDate != null) {
            expression.append("and trans_date=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)transDate));
        }
        expression.append("and todays_flag=?").append(' ');
        paramsList.add("1");
        String expressionStr = expression.toString();
        if (StringUtils.isNotEmpty((String)expressionStr)) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findByCustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersion) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        String orderBy = "sort desc";
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus}, (String)orderBy);
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)orderBy);
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findByCoustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersion) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(String customId, List<Integer> statusArray, String bankVersion, LocalDate transDate, String bankLogin) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)bankLogin)) {
            expression.append("and bank_login.number=?").append(' ');
            paramsList.add(bankLogin);
        }
        if (transDate != null) {
            expression.append("and trans_date=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)transDate));
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = new QFilter("status", "in", statusList);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            return dynamicObjects;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public DynamicObject[] findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(String bankVersion, String customId, LocalDate startDate, LocalDate endDate) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (startDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)startDate));
        }
        if (endDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)endDate));
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        String orderBy = "receipt_num desc";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)orderBy);
        return dynamicObjects;
    }

    public DynamicObject[] findUnUploadCompleteTaskByBankAndCustomId(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        QFilter filter1;
        QFilter filter;
        DynamicObjectCollection collection;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (startDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(startDate);
        }
        if (endDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(endDate);
        }
        expression.append("and status=?").append(' ');
        paramsList.add(String.valueOf(TaskStatusEnum.FINISH.getId()));
        String expressionStr = expression.toString();
        if (StringUtils.isNotEmpty((String)expressionStr)) {
            expressionStr = expression.toString().substring(3);
        }
        if ((collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray()), filter1 = new QFilter("upload_flag", "in", Arrays.asList(String.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()), String.valueOf(UploadTaskStatusEnum.UPLOAD_PROCESSING.getId())))})) != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject findById(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public void save(DynamicObject dynamicObject) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void batchSave(DynamicObject[] dynamicObjects) {
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void batchUpdate(DynamicObject[] dynamicObjects) {
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void update(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void delete(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])filter.toArray());
        }
    }

    public void batchDelete(String[] ids) {
        if (ids != null && ids.length > 0) {
            DynamicObjectType dynamicObjectType = new DynamicObjectType(ENTITY_NAME);
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])ids);
        }
    }

    public boolean exitsByBankVersionAndAccnoAndTransDate(String bankVersion, String accno, Date transDate) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("bank_version.number", "=", (Object)bankVersion), new QFilter("acc_no.number", "=", (Object)accno), new QFilter("trans_date", "=", (Object)transDate)});
    }

    public String packInOfStrByList(String filed, List<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(filed).append(" in (");
        for (int i = 0; i < arrayList.size(); ++i) {
            String str = arrayList.get(i);
            stringBuilder.append("'");
            stringBuilder.append(str);
            stringBuilder.append("'");
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public int countTaskNumByBankVersionIDAndTransDateAndCustomId(String bankVersionId, LocalDate transDate, String customId) {
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=?  and trans_date=?", (Object[])new Object[]{customId, bankVersionId, transDate});
        DataSet ds = QueryServiceHelper.queryDataSet((String)ReceiptDownloadTaskRepository.class.getName(), (String)ENTITY_NAME, (String)"id", (QFilter[])filter.toArray(), (String)"");
        int total = ds.count("id", Boolean.FALSE.booleanValue());
        return total;
    }

    public int countFinishTaskNumByBankVersionIDAndTransDateAndCustomId(String bankVersionId, LocalDate transDate, String customId) {
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date=? and status=?", (Object[])new Object[]{customId, bankVersionId, transDate, Integer.toString(TaskStatusEnum.FINISH.getId())});
        DataSet ds = QueryServiceHelper.queryDataSet((String)ReceiptDownloadTaskRepository.class.getName(), (String)ENTITY_NAME, (String)"id", (QFilter[])filter.toArray(), (String)"");
        int total = ds.count("id", Boolean.FALSE.booleanValue());
        return total;
    }

    public DynamicObject[] batchFindById(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public DynamicObject[] findByCustomIdAndBankLoginAndTransDateAndStatus(String customId, String bankLoginId, LocalDate startDate, LocalDate endDate, int status) {
        return this.findByComplexCondition(null, null, bankLoginId, startDate, endDate, status, customId);
    }
}

