/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils.ofd;

import java.util.List;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.ofd.OfdErrorType;
import kd.ebg.receipt.common.utils.ofd.XmlUtil;
import org.jdom2.Document;
import org.jdom2.Element;

public class OfdReadUtil {
    private static final EBGLogger LOGGER = EBGLogger.getInstance().getLogger(OfdReadUtil.class);

    public static Element getElementByByte(byte[] fileByte) {
        try {
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.info(OfdErrorType.LOAD_ERROR.getDescription());
            throw new ReceiptException(e);
        }
    }

    public static StringBuilder getLastDirPath(String path) {
        String[] pathArr;
        StringBuilder buffer = new StringBuilder();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append("/");
        }
        return buffer;
    }

    public static String getDirPath(String path, String lastPath) {
        if (!StringUtils.isEmpty((String)path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!StringUtils.isEmpty((String)lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text = "";
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")) != null && arr.length == 2) {
                    List elementList = elementNow.getChildren(arr[0], elementNow.getNamespace());
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.getAttributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                if (elementNow.getChild(dir, elementNow.getNamespace()) != null) {
                    elementNow = elementNow.getChild(dir, elementNow.getNamespace());
                    continue;
                }
                return null;
            }
            text = OfdReadUtil.removeStartSymbol(elementNow.getText(), "/");
            return text;
        }
        catch (Exception e) {
            LOGGER.info(OfdErrorType.EXTRACT_ERROR.getDescription());
            return text;
        }
    }

    private static String removeStartSymbol(String str, String symbol) {
        while (!StringUtils.isEmpty((String)str) && str.startsWith(symbol)) {
            str = str.substring(1);
        }
        return str;
    }
}

