/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils.reconciliation;

import com.google.common.base.Preconditions;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BalanceReconciliationUtils {
    public static String getAccNoByBankCodeAndNull(String bankCode, String nullAccNo) {
        List bankAcnts;
        if (StringUtils.isNotEmpty((String)nullAccNo)) {
            return nullAccNo;
        }
        String bankVersion = bankCode;
        if (bankCode.equalsIgnoreCase("BC-0025")) {
            bankVersion = "BOC_NET";
        }
        Preconditions.checkArgument((!(bankAcnts = BankAcntService.getInstance().selectReconciliationByCustomIdAndBankVersion(EBContext.getContext().getCustomID(), bankVersion)).isEmpty() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6ca1\u6709\u94f6\u884c\u8d26\u53f7\uff0c\u8bf7\u5148\u6dfb\u52a0\u94f6\u884c\u8d26\u53f7\u3002", (String)"BalanceReconciliationUtils_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        String accNo = ((BankAcnt)bankAcnts.get(0)).getAccNo();
        return accNo;
    }

    public static String getAccNoByBalanceReconciliationAndNull(String bankCode, String nullAccNo, String reconciliationNo) {
        ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository;
        List<ReconciliationDetail> details;
        if (StringUtils.isNotEmpty((String)nullAccNo)) {
            return nullAccNo;
        }
        String bankVersion = bankCode;
        if (bankCode.equalsIgnoreCase("BC-0025")) {
            bankVersion = "BOC_NET";
        }
        Preconditions.checkArgument((!(details = (reconciliationDownloadListDetailRepository = SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class)).findByReconciliationNo(reconciliationNo)).isEmpty() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u8be5\u5bf9\u8d26\u5355\u53f7[%s]\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"BalanceReconciliationUtils_1", (String)"ebg-receipt-common", (Object[])new Object[0]), reconciliationNo));
        String bankLoginId = details.get(0).getBankLoginId();
        List bankAcnts = BankAcntService.getInstance().findByBankVersionIdAndBankLoginIdAndHasReconciliation(bankVersion, bankLoginId, true);
        Preconditions.checkArgument((!bankAcnts.isEmpty() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u6ca1\u6709\u94f6\u884c\u8d26\u53f7\uff0c\u8bf7\u5148\u6dfb\u52a0\u94f6\u884c\u8d26\u53f7\u3002", (String)"BalanceReconciliationUtils_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        String accNo = ((BankAcnt)bankAcnts.get(0)).getAccNo();
        return accNo;
    }
}

