/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zrc.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZRC_DC", (String)accNo, (String)transDateStr);
        String tempBakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZRC_DC", (String)accNo, (String)"Temp");
        tempBakFilePath = FileCommonUtils.checkPath((String)tempBakFilePath);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp();
        }
        boolean isLastFile = false;
        ArrayList result = new ArrayList(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            boolean flag;
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() || detail.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".pdf") || !(flag = this.download(detail, tempBakFilePath, isLastFile, bankFtpProperties, sftp))) continue;
            if (!GZFileUtils.unZipFiles((String)(tempBakFilePath + File.separator + detail.getFileName()), (String)tempBakFilePath)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305[%s]\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]), detail.getFileName()));
            }
            logger.info(">>>>>>>>>FileCommonUtils\u4f7f\u7528A");
            FileCommonUtils.getFileByPath((String)(tempBakFilePath + detail.getFileName())).delete();
            RequestContextUtils.setZipName((String)detail.getFileName());
            try (Stream<Path> paths = Files.walk(Paths.get(tempBakFilePath, new String[0]), new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                    logger.info(">>>>>>>>>FileCommonUtils\u4f7f\u7528B");
                    boolean isMove = FileCommonUtils.moveFile((File)f, (String)bakFilePath, (String)f.getName());
                    logger.info(">>>>>>>>>>>>>>>isMove\u7684\u503c\u4e3a{}\uff0c\u6b63\u5728\u8bbf\u95ee\u7684\u6587\u4ef6\u540d\u4e3a{}", new Object[]{isMove, f.getName()});
                    if (isMove) {
                        DownloadListDetail detail1 = new DownloadListDetail();
                        detail1.setFileLink(detail.getFileLink());
                        detail1.setFileName(f.getName());
                        result.add(detail1);
                    }
                });
            }
            catch (IOException e) {
                logger.error("\u5f20\u5bb6\u6e2f\u519c\u5546\u884c\u56de\u5355\u6587\u4ef6\u8f6c\u79fb\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ReceiptException((Throwable)e);
            }
            logger.info(">>>>>>>>>FileCommonUtils\u4f7f\u7528C");
            this.deleteDir(FileCommonUtils.getFileByPath((String)tempBakFilePath));
        }
        logger.info(">>>>>>>>>\u5f20\u5bb6\u6e2f\u519c\u5546\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
        boolean result = false;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        if (fileName != null && fileName.length() > 0) {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                result = this.ftpDownload(destFolder, fileName, isLastFile, ftpPath, newFileName, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                result = this.localDownload(fileName, detail.getAccNo(), detail.getTransDate(), destFolder);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String destFolder, String orgFileName, boolean isLastFile, String ftpPath, String newFileName, ChannelSftp sftp) {
        boolean result;
        logger.info("\u4e0b\u8f7d\u5f20\u5bb6\u6e2f\u519c\u5546\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
            logger.info(">>>>>>>>>FileCommonUtils\u4f7f\u7528D");
            File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + orgFileName));
            if (file.exists()) {
                result = FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
            }
        }
        catch (Exception e) {
            result = false;
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + orgFileName, (Throwable)e);
        }
        finally {
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    private boolean localDownload(String orgFileName, String accNo, LocalDate transDate, String destFolder) {
        logger.info("\u4e0b\u8f7d\u5f20\u5bb6\u6e2f\u519c\u5546\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName, destFolder);
    }

    private void deleteDir(File file) {
        if (file.isFile()) {
            boolean isDelete = file.delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            } else {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDir(files[i]);
                }
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            }
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ZRC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-zrc-dc", (Object[])new Object[0]);
    }
}

