/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjrc.dc.service.api.receipt;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zjrc.dc.service.api.ZJRCDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class DownLoadBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadBankReceiptImpl.class);
    private static final String TRANCODE_100024 = "100024";

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = DownLoadBankReceiptImpl.getCommonHeader(TRANCODE_100024, Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        Map paramsMap = bankReceiptRequest.getParamsMap();
        JDomUtils.addChild((Element)reqBody, (String)"warrantType", (String)((String)paramsMap.get("warrantType")));
        JDomUtils.addChild((Element)reqBody, (String)"accountNo", (String)bankReceiptRequest.getAccNo());
        Element yqElecWarrantFlowNoList = JDomUtils.addChild((Element)reqBody, (String)"yqElecWarrantFlowNoList");
        Element row = JDomUtils.addChild((Element)yqElecWarrantFlowNoList, (String)"reqBody");
        JDomUtils.addChild((Element)row, (String)"tellerSeqNo", (String)((String)paramsMap.get("tellerSeqNo")));
        JDomUtils.addChild((Element)row, (String)"subTranFlow", (String)((String)paramsMap.get("subTranFlow")));
        JDomUtils.addChild((Element)row, (String)"date", (String)((String)paramsMap.get("transferTime")));
        return DownLoadBankReceiptImpl.getPostParams(root, TRANCODE_100024);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        if (s.contains(ResManager.loadKDString((String)"<caption>\u94f6\u4f01\u7535\u5b50\u56de\u5355</caption>", (String)"DownLoadBankReceiptImpl_0", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]))) {
            s = s.replace(ResManager.loadKDString((String)"<button class=\"submit\" id=\"printBtn\">\u6253&nbsp;&nbsp;\u5370</button>", (String)"DownLoadBankReceiptImpl_1", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), "");
            s = s.replace(ResManager.loadKDString((String)"<button class=\"reset\" id=\"close\">\u5173&nbsp;&nbsp;\u95ed</button>", (String)"DownLoadBankReceiptImpl_2", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), "");
            return BankReceiptResponseEB.success((Object)s);
        }
        if (s.contains(ResManager.loadKDString((String)"\u8bb0\u5f55\u672a\u627e\u5230", (String)"DownLoadBankReceiptImpl_3", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]))) {
            return BankReceiptResponseEB.success((Object)"nil");
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"DownLoadBankReceiptImpl_7", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), s));
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "0095";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u6587\u4ef6\u6d41\u3002", (String)"DownLoadBankReceiptImpl_5", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public static Element getCommonHeader(String code, String seqNo) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        Element root = JDomUtils.createRoot((String)"ebank");
        Element reqHead = JDomUtils.addChild((Element)root, (String)"reqHead");
        JDomUtils.addChild((Element)reqHead, (String)"custNo", (String)config.getCorpNo());
        JDomUtils.addChild((Element)reqHead, (String)"userId", (String)config.getOpNo());
        JDomUtils.addChild((Element)reqHead, (String)"tranCode", (String)code);
        JDomUtils.addChild((Element)reqHead, (String)"serialNo", (String)seqNo);
        Date now = new Date();
        JDomUtils.addChild((Element)reqHead, (String)"reqDate", (String)DateUtil.formatDate((Date)now, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqHead, (String)"reqTime", (String)new SimpleDateFormat("HHmmssSSS").format(now));
        return root;
    }

    public static String getPostParams(Element root, String transCode) {
        String content;
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        String params = "tranCode=" + transCode + "&url=" + config.getSignProtocol() + "://" + config.getSING_SERVER_IP() + ":" + config.getSIGN_PORT() + "/bce/bceElecWarrent.do&transData=";
        String charset = RequestContextUtils.getCharset();
        try {
            String requestStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)charset);
            logger.info("\u4ea4\u6613\u7801\uff1a{}-\u8bf7\u6c42\u53c2\u6570\u660e\u6587\uff1a{}", new Object[]{transCode, requestStr});
            content = URLEncoder.encode(requestStr, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u4e0d\u652f\u6301%s\u3002", (String)"DownLoadBankReceiptImpl_8", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), charset), (Throwable)e);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return params + content;
    }
}

