/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjrc.dc.service.api.receipt;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zjrc.dc.service.api.ZJRCDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class FetchBankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FetchBankReceiptImpl.class);
    private static final String TRANCODE_100025 = "100025";

    public List<Map<String, Object>> process(BankReceiptRequest request) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(8);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            BankReceiptResponseEB response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getData())) continue;
            ret.addAll((List)response.getData());
        }
        return ret;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String curDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String accNo = bankReceiptRequest.getAccNo();
        Map paramsMap = bankReceiptRequest.getParamsMap();
        Element root = FetchBankReceiptImpl.getCommonHeader(TRANCODE_100025, Sequence.genSequence());
        String warrantType = (String)paramsMap.get("warrantType");
        String warrantSign = (String)paramsMap.get("warrantSign");
        String businessType = (String)paramsMap.get("businessType");
        String tellerSeqNo = (String)paramsMap.get("tellerSeqNo");
        String subTranFlow = (String)paramsMap.get("subTranFlow");
        String date = (String)paramsMap.get("date");
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)reqBody, (String)"beginDate", (String)curDate);
        JDomUtils.addChild((Element)reqBody, (String)"endDate", (String)curDate);
        JDomUtils.addChild((Element)reqBody, (String)"warrantType", (String)warrantType);
        JDomUtils.addChild((Element)reqBody, (String)"warrantSign", (String)warrantSign);
        JDomUtils.addChild((Element)reqBody, (String)"businessType", (String)businessType);
        JDomUtils.addChild((Element)reqBody, (String)"tellerSeqNo", (String)tellerSeqNo);
        JDomUtils.addChild((Element)reqBody, (String)"subTranFlow", (String)subTranFlow);
        JDomUtils.addChild((Element)reqBody, (String)"date", (String)date);
        JDomUtils.addChild((Element)reqBody, (String)"extend", (String)"");
        return FetchBankReceiptImpl.getPostParams(root, TRANCODE_100025);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        logger.info("\u8fd4\u56de\u7684\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u662f==================>>>", (Object)s);
        this.setLastPage(true);
        Element ebank = JDomUtils.string2Root((String)s, (String)"UTF-8");
        Element resHead = JDomUtils.getUnNullChildElement((Element)ebank, (String)"resHead");
        String retCode = JDomUtils.getUnNullChildTextTrim((Element)resHead, (String)"retCode");
        ArrayList result = new ArrayList(16);
        if (!"0000".equalsIgnoreCase(retCode)) {
            String errMsg = JDomUtils.getUnNullChildTextTrim((Element)resHead, (String)"errMsg");
            if (errMsg.contains(ResManager.loadKDString((String)"\u8bb0\u5f55\u672a\u627e\u5230", (String)"FetchBankReceiptImpl_0", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]))) {
                logger.info("\u4ea4\u6613\u8fd4\u56de\u7801[" + retCode + "]:" + errMsg);
                return BankReceiptResponseEB.success();
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u4ea4\u6613\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"FetchBankReceiptImpl_4", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), retCode, errMsg));
        }
        Element resBody = JDomUtils.getUnNullChildElement((Element)ebank, (String)"resBody");
        Map paramMap = bankReceiptRequest.getParamsMap();
        String tellerSeqNo = JDomUtils.getUnNullChildText((Element)resBody, (String)"tellerSeqNo");
        String subTranFlow = JDomUtils.getUnNullChildText((Element)resBody, (String)"subTranFlow");
        String flag = JDomUtils.getUnNullChildText((Element)resBody, (String)"flag");
        String date = JDomUtils.getUnNullChildText((Element)resBody, (String)"date");
        if ("0".equalsIgnoreCase(flag)) {
            paramMap.put("tellerSeqNo", tellerSeqNo);
            paramMap.put("subTranFlow", subTranFlow);
            paramMap.put("date", date);
            this.setLastPage(false);
        } else {
            this.setLastPage(true);
        }
        Element yqElecWarrantFlowNoList = JDomUtils.getUnNullChildElement((Element)resBody, (String)"yqElecWarrantList");
        List rowList = yqElecWarrantFlowNoList.getChildren("row");
        for (Element row : rowList) {
            HashMap<String, String> info = new HashMap<String, String>(4);
            info.put("tellerSeqNo", JDomUtils.getUnNullChildTextTrim((Element)row, (String)"tellerSeqNo"));
            info.put("subTranFlow", JDomUtils.getUnNullChildTextTrim((Element)row, (String)"subTranFlow"));
            info.put("transferTime", JDomUtils.getUnNullChildTextTrim((Element)row, (String)"transferTime"));
            result.add(info);
        }
        return BankReceiptResponseEB.success(result);
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "0095";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u6587\u4ef6\u6d41\u3002", (String)"FetchBankReceiptImpl_2", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public static Element getCommonHeader(String code, String seqNo) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        Element root = JDomUtils.createRoot((String)"ebank");
        Element reqHead = JDomUtils.addChild((Element)root, (String)"reqHead");
        JDomUtils.addChild((Element)reqHead, (String)"custNo", (String)config.getCorpNo());
        JDomUtils.addChild((Element)reqHead, (String)"userId", (String)config.getOpNo());
        JDomUtils.addChild((Element)reqHead, (String)"tranCode", (String)code);
        JDomUtils.addChild((Element)reqHead, (String)"serialNo", (String)seqNo);
        Date now = new Date();
        JDomUtils.addChild((Element)reqHead, (String)"reqDate", (String)DateUtil.formatDate((Date)now, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqHead, (String)"reqTime", (String)new SimpleDateFormat("HHmmssSSS").format(now));
        return root;
    }

    public static String getPostParams(Element root, String transCode) {
        String content;
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        String params = "tranCode=" + transCode + "&url=" + config.getSignProtocol() + "://" + config.getSING_SERVER_IP() + ":" + config.getSIGN_PORT() + "/" + config.getBANK_REQUST_URI() + "&transData=";
        String charset = RequestContextUtils.getCharset();
        try {
            String requestStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)charset);
            logger.info("\u4ea4\u6613\u7801\uff1a{}-\u8bf7\u6c42\u53c2\u6570\u660e\u6587\uff1a{}", new Object[]{transCode, requestStr});
            content = URLEncoder.encode(requestStr, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u5b57\u7b26\u96c6\u4e0d\u652f\u6301\u3002", (String)"FetchBankReceiptImpl_5", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), charset), (Throwable)e);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return params + content;
    }
}

