/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjrc.dc.service.api.receipt;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zjrc.dc.service.api.ZJRCDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class TransformRemoteFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final String BIZ_TYPE = "H2P";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TransformRemoteFileImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String fileName = (String)paramsMap.get("fileName");
        String fileContent = (String)paramsMap.get("fileContent");
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = TransformRemoteFileImpl.createHead(BIZ_TYPE);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName.substring(0, fileName.indexOf(".pdf")));
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)fileContent);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        Element root = JDomUtils.string2Root((String)s, (String)"UTF-8");
        BankResponse bankResponse = TransformRemoteFileImpl.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(bankResponse.getResponseCode())) {
            logger.error("\u54cd\u5e94\u53c2\u6570\uff1a{}", new Object[]{s});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 %s", (String)"TransformRemoteFileImpl_2", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        Element body = JDomUtils.getUnNullChildElement((Element)root, (String)"body");
        Element rspPara = JDomUtils.getUnNullChildElement((Element)body, (String)"rspPara");
        String base64Content = JDomUtils.getUnNullChildText((Element)rspPara, (String)"fileContent");
        return BankReceiptResponseEB.success((Object)base64Content);
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "proxy_req";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u8f6c\u6362html\u6587\u4ef6\u4e3apdf\u3002", (String)"TransformRemoteFileImpl_1", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        String frontPort = config.getFrontPort();
        factory.setPort(frontPort);
    }

    public static Element createHead(String bizType) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)Sequence.genSequence());
        return head;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getUnNullChildElement((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getUnNullChildTextTrim((Element)Head, (String)"rspcode");
        String IBSReturnMsg = JDomUtils.getUnNullChildTextTrim((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

