/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.njb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        try {
            this.init(request);
            long taskId = request.getTaskId();
            String accNo = request.getAccNo();
            LocalDate transDate = request.getTransDate();
            String bankLogin = request.getBankLoginId();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
            List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"NJB_DC", (String)accNo, (String)transDateStr);
            BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
            ChannelSftp sftp = null;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            boolean isLastFile = false;
            ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
            logger.info(">>>>>>>>>\u5357\u4eac\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
            for (int i = 0; i < downloadListDetails.size(); ++i) {
                DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
                if (i == downloadListDetails.size() - 1) {
                    isLastFile = true;
                }
                String newName = detail.getFileName();
                boolean flag = this.download(detail, bakFilePath, isLastFile, bankFtpProperties, sftp);
                if (!flag) continue;
                logger.info("SFTP\u4f20\u8f93\u6210\u529f\u4e4b\u540e\u7684\u5904\u7406");
                Path path = Paths.get(bakFilePath + File.separator + newName, new String[0]);
                try {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    logger.info("\u6210\u529f\u521b\u5efa\u56de\u5355");
                    detail.setFileName(newName);
                    detail.setFileLink(newName);
                    result.add(detail);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u5357\u4eac\u94f6\u884c\u7535\u5b50\u56de\u5355\u6587\u4ef6\u8f6c\u79fb\u5f02\u5e38\uff1a", (Throwable)e);
                    throw new ReceiptException((Throwable)e);
                }
            }
            logger.info(">>>>>>>>>>>>>>>\u5357\u4eac\u94f6\u884c\u56de\u5355\u7ed3\u679c{}", result);
            return BankReceiptHandleResponseEB.success(result);
        }
        catch (Exception e) {
            logger.info(">>>>>>>>>>>>>>>\u5357\u4eac\u94f6\u884c\u56de\u5355\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public boolean download(DownloadListDetail detail, String destFolder, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
        boolean result = false;
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        if (fileName != null && fileName.length() > 0) {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                result = this.ftpDownload(destFolder, fileName, isLastFile, ftpPath, newFileName, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                result = this.localDownload(fileName, detail.getAccNo(), detail.getTransDate(), destFolder);
                File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + fileName));
                if (file.exists()) {
                    FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String destFolder, String orgFileName, boolean isLastFile, String ftpPath, String newFileName, ChannelSftp sftp) {
        boolean result;
        logger.info("\u4e0b\u8f7d\u5357\u4eac\u94f6\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
            logger.info(">>>>>>>>>FileCommonUtils\u4f7f\u7528D");
            File file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + orgFileName));
            if (file.exists()) {
                FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
            }
        }
        catch (Exception e) {
            result = false;
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + orgFileName, new Object[]{e.getMessage()});
        }
        finally {
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    private boolean localDownload(String orgFileName, String accNo, LocalDate transDate, String destFolder) {
        logger.info("\u4e0b\u8f7d\u5357\u4eac\u94f6\u884c\u6587\u4ef6\u540d\uff1a" + orgFileName);
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName, destFolder);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "JSB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]);
    }
}

