/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.HxbDcFileParser;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.api.HxbDcReceiptDownload;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;
    private static final String TRANSCODE = "DLEDCDTD";
    private static final String SUCCESS = "AAAAAAA";

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"HXB_DC", (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail detail = (DownloadListDetail)downloadListDetails.get(i);
            HxbDcFileParser hxbDcFileParser = new HxbDcFileParser();
            hxbDcFileParser.setFileName(detail.getFileName());
            if (hxbDcFileParser.getFileSplitLength() < 6) {
                this.downloadListDetailService.deleteById(detail.getId());
                continue;
            }
            if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(detail);
                continue;
            }
            boolean flag = this.download(detail, bakFilePath);
            if (!flag) continue;
            result.add(detail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder) {
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        String fileName = detail.getFileName();
        String requestStr = detail.getFileLink();
        JSONObject jsonObject = JSONObject.parseObject((String)requestStr);
        String billCode = jsonObject.getString("billCode");
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)16);
        paramsMap.put("billCode", billCode);
        paramsMap.put("fileName", fileName);
        paramsMap.put("bakFilePath", destFolder);
        BankReceiptRequest bankDetailRequest = BankReceiptRequest.builder().paramsMap((Map)paramsMap).accNo(accNo).transDate(transDate).build();
        HxbDcReceiptDownload hxbDcReceiptDownload = new HxbDcReceiptDownload();
        BankReceiptResponseEB bankReceiptResponseEB = hxbDcReceiptDownload.doBiz(bankDetailRequest);
        return Objects.equals(bankReceiptResponseEB.getCode(), BankReceiptResponseEB.ResultEnum.SUCCESS.getCode());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZSB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]);
    }
}

