/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt.api;

import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.ResponseStrUtil;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.api.ReceiptPacker;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class HxbDcReceiptDownload
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HxbDcReceiptDownload.class);

    public String pack(BankReceiptRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAccNo();
        String transDateStr = bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Map paramsMap = bankDetailRequest.getParamsMap();
        String billCode = (String)paramsMap.get("billCode");
        String receiptRequest = ReceiptPacker.packXhj8036(accNo, bankDetailRequest.getTransDate(), billCode);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return receiptRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String[] elements;
        String oldResponseStr = responseStr;
        EBContext.getContext().setRemoveWriteResponseLog(false);
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (responseStr.length() < 1000) {
            logger.info("\u534e\u590f\u94f6\u884c\u2014\u2014xhj8036\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94-{}-{}\uff1a{}", new Object[]{accNo, transDateStr, responseStr});
        }
        if ((elements = EBGStringUtils.split((String)(responseStr = ResponseStrUtil.process(responseStr)), (String)"#")) == null || elements.length < 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"HxbDcReceiptDownload_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        String fileBase = elements[1];
        if (StringUtils.isNotEmpty((String)fileBase)) {
            Map paramsMap = request.getParamsMap();
            String fileName = (String)paramsMap.get("fileName");
            String bakFilePath = (String)paramsMap.get("bakFilePath");
            try {
                if (FileCommonUtils.base64ToFile((String)fileBase, (String)(bakFilePath + File.separator + fileName))) {
                    return BankReceiptResponseEB.success();
                }
            }
            catch (Throwable e) {
                logger.info("\u534e\u590f\u94f6\u884c\u2014\u2014xhj8036\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94\uff1a\n{}", (Object)oldResponseStr);
                logger.info("\u534e\u590f\u94f6\u884c\u2014\u2014xhj8036\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94\u7684base64\u5b57\u7b26\u4e32\uff1a\n{}", (Object)fileBase);
                throw e;
            }
        }
        return BankReceiptResponseEB.fail((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684FileBase\u5b57\u6bb5\u6709\u8bef\u3002", (String)"HxbDcReceiptDownload_1", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "xhj8036";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"PDF\u683c\u5f0f\u7535\u5b50\u56de\u5355\u4e0b\u8f7d", (String)"HxbDcReceiptDownload_2", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

