/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdb.ccip.service.receipt.download;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cdb.ccip.service.receipt.api.BankReceiptDownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CBS_RECEIPT_DOWNLOAD";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CDB_CCIP", (String)accNo, (String)transDateStr);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (!this.download(downloadListDetail, bakFilePath, request)) continue;
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail downloadListDetail, String bakFilePath, BankReceiptHandleRequest request) {
        if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
            return true;
        }
        String fileLink = downloadListDetail.getFileLink();
        String fileName = downloadListDetail.getFileName();
        BankReceiptDownloadImpl download = new BankReceiptDownloadImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(request.getAccNo()).transDate(request.getTransDate()).requestStr(fileLink).build();
        BankReceiptResponseEB bankReceiptResponseEB = download.doBiz(bankReceiptRequest);
        String fileContent = (String)bankReceiptResponseEB.getData();
        if (StringUtils.isNotEmpty((String)fileContent)) {
            StringBuilder filePath = new StringBuilder();
            filePath.append(bakFilePath).append(File.separator).append(fileName);
            boolean flag = false;
            try {
                File file = FileCommonUtils.getFileByPath((String)filePath.toString());
                if (file.exists()) {
                    file.delete();
                }
                byte[] response = Base64.getDecoder().decode(fileContent);
                flag = FileCommonUtils.write2File((byte[])response, (String)filePath.toString());
            }
            catch (Exception e) {
                logger.error("\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
            }
            return flag;
        }
        return false;
    }
}

