/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.cib.dc.services.receipt.ReceiptPacker;
import kd.ebg.receipt.banks.cib.dc.services.receipt.ReceiptPage;
import kd.ebg.receipt.banks.cib.dc.services.receipt.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginReceiptProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class ReceiptImpl
extends AbstractReceiptImpl
implements IReceipt {
    private String pageTag;

    public String getDeveloper() {
        return "zhangjie";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u7535\u5b50\u56de\u5355", (String)"ReceiptImpl_0", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]);
    }

    public ReceiptResponseEB queryReceipt(ReceiptRequest request) {
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        boolean lastPage = false;
        ArrayList receiptInfos = new ArrayList(16);
        this.pageTag = ReceiptPage.getFirstPageTag();
        while (!lastPage) {
            responseEB = this.doBiz(request);
            if (responseEB != null && !responseEB.getReceiptInfos().isEmpty()) {
                receiptInfos.addAll(responseEB.getReceiptInfos());
            }
            lastPage = ReceiptPage.isLastPage(this.pageTag);
        }
        if (Objects.nonNull(responseEB)) {
            responseEB.setReceiptInfos(receiptInfos);
        }
        return responseEB;
    }

    public String pack(ReceiptRequest request) {
        return ReceiptPacker.pack(request, this.pageTag);
    }

    public ReceiptResponseEB parse(ReceiptRequest request, String responseStr) {
        this.pageTag = ReceiptPage.getNextPageTag(responseStr, this.pageTag);
        return ReceiptParser.parse(request, responseStr);
    }

    public boolean match(ReceiptRequest request) {
        if (RequestContextUtils.receiptFormatIsFile()) {
            return false;
        }
        if (request.getHeader() != null) {
            String bankLoginId = request.getHeader().getBankLoginID();
            BankLoginReceiptProperties bankLoginReceiptProperties = (BankLoginReceiptProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginReceiptProperties.class, bankLoginId);
            if (Objects.equals(bankLoginReceiptProperties.getIsNSyncDownloadReceipt(), "off")) {
                return true;
            }
            return Objects.equals(request.getHeader().getClientName(), "SYSTEM_RECEIPT_API");
        }
        return false;
    }
}

