/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt.api;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cib.dc.services.receipt.CibDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class GetBankReceiptNameApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptNameApiImpl.class);

    public String pack(BankReceiptRequest request) {
        Map paramMap = request.getParamsMap();
        String cltRefNo = (String)paramMap.get("cltRefNo");
        int page = (Integer)paramMap.get("page");
        String requestXml = this.buildAsynReceiptReq(cltRefNo, page);
        return requestXml;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u5174\u4e1a\u94f6\u884c\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868-\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        return BankReceiptResponseEB.success((Object)responseStr);
    }

    private String buildAsynReceiptReq(String cltRefNo, int page) {
        Element head = this.buildHeadMessage();
        Element sec = JDomUtils.addChild((Element)head, (String)"SECURITIES_MSGSRQV1");
        Element asy = JDomUtils.addChild((Element)sec, (String)"ASYNRECEIPTINFOTRNRQ");
        JDomUtils.addChild((Element)asy, (String)"TRNUID", (String)Sequence.genSequence());
        Element rqb = JDomUtils.addChild((Element)asy, (String)"RQBODY");
        rqb.setAttribute("PAGE", page + "");
        JDomUtils.addChild((Element)rqb, (String)"CLT_REF_NO", (String)cltRefNo);
        return JDomUtils.element2StringPlain((Element)head, (String)"GBK");
    }

    private Element buildHeadMessage() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CibDcCommConfig config = (CibDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CibDcCommConfig.class, bankLoginId);
        Element cms = new Element("FOX");
        Element eb = JDomUtils.addChild((Element)cms, (String)"SIGNONMSGSRQV1");
        Element pub = JDomUtils.addChild((Element)eb, (String)"SONRQ");
        JDomUtils.addChild((Element)pub, (String)"DTCLIENT", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JDomUtils.addChild((Element)pub, (String)"CID", (String)config.getReceiptFetchListClientId());
        JDomUtils.addChild((Element)pub, (String)"USERID", (String)config.getReceiptFetchListUserId());
        JDomUtils.addChild((Element)pub, (String)"USERPASS", (String)config.getReceiptFetchListPwd());
        JDomUtils.addChild((Element)pub, (String)"GENUSERKEY", (String)"N");
        JDomUtils.addChild((Element)pub, (String)"LANGUAGE", (String)"CHS");
        JDomUtils.addChild((Element)pub, (String)"APPID", (String)"");
        JDomUtils.addChild((Element)pub, (String)"APPVER", (String)"1.0");
        return cms;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CIB_DC_RECEIPT_NAME";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u540d", (String)"GetBankReceiptNameApiImpl_0", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-fox");
    }
}

