/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt;

import java.net.MalformedURLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.AccessUtils;
import kd.ebg.receipt.business.receipt.utils.ReceiptConvert;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponse;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponseBody;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.slf4j.MDC;

public class ReceiptPageMethod
implements EBServiceMethod<QueryReceiptRequest, QueryReceiptResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPageMethod.class);

    public QueryReceiptResponse executeClientRequest(QueryReceiptRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        ReceiptRequest receiptRequest = ReceiptConvert.convert(request);
        String startDateStr = request.getBody().getStartDate();
        String endDateStr = request.getBody().getEndDate();
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        ObjectPropertyService objectPropertyService = ObjectPropertyService.getInstance();
        String bankVersionID = context.getBankVersionID();
        String detailSerachDateStr = objectPropertyService.getBankSearchDetailDate(bankVersionID);
        String accnoSearchLimit = objectPropertyService.getAccnoSearchLimit(receiptRequest.getAccNo());
        if (StringUtils.isNotEmpty((String)detailSerachDateStr) && Objects.equals(accnoSearchLimit, "false")) {
            LocalDate detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE);
            if (endDate.isBefore(detailSearchDate = detailSearchDate.minusDays(1L))) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5728\u9650\u5236\u67e5\u8be2\u65e5\u671f[%s]\u4e4b\u524d\u3002", (String)"ReceiptPageMethod_2", (String)"ebg-receipt-business", (Object[])new Object[0]), detailSerachDateStr));
            }
            if (startDate.isBefore(detailSearchDate)) {
                startDate = detailSearchDate;
                receiptRequest.setStartDate(startDate);
                logger.info("\u5f00\u59cb\u65e5\u671f\u5728\u9650\u5236\u65e5\u671f{}\u4e4b\u524d\uff0c\u4fee\u6539\u5f00\u59cb\u65e5\u671f\u4e3a\u9650\u5236\u65e5\u671f{}", new Object[]{detailSerachDateStr, detailSerachDateStr});
            }
        }
        receiptRequest.setPageNum(request.getBody().getPageNum());
        receiptRequest.setPageSize(request.getBody().getPageSize());
        receiptRequest.getHeader().setSubBizType("receiptPage");
        ReceiptResponseEB response = null;
        EBContext.initParameter();
        FEPAccess access = null;
        QueryReceiptResponse queryReceiptResponse = new QueryReceiptResponse();
        try {
            IReceipt receiptPageImpl = (IReceipt)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IReceipt.class, (Object)receiptRequest);
            if (receiptPageImpl.needLock()) {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankVersionID());
                AccessUtils.checkQueryAllowed(context);
            }
            response = receiptPageImpl.queryReceipt(receiptRequest);
            queryReceiptResponse = ReceiptConvert.convert(response);
            QueryReceiptResponseBody body = queryReceiptResponse.getBody();
            body.setPageNum(response.getPageNum());
            body.setPageSize(response.getPageSize());
            body.setTotalCount(response.getTotalCount());
            body.setLastPage(response.isLastPage());
        }
        catch (Exception e) {
            try {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        return queryReceiptResponse;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "receiptPage";
    }
}

