/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt;

import java.net.MalformedURLException;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.AccessUtils;
import kd.ebg.receipt.business.receipt.utils.ReceiptConvert;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponse;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponseBody;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class ReconciliationPageMethod
implements EBServiceMethod<QueryReceiptRequest, QueryReceiptResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReconciliationPageMethod.class);

    public QueryReceiptResponse executeClientRequest(QueryReceiptRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        ReceiptRequest receiptRequest = ReceiptConvert.convert(request);
        receiptRequest.setPageNum(request.getBody().getPageNum());
        receiptRequest.setPageSize(request.getBody().getPageSize());
        receiptRequest.getHeader().setSubBizType("receiptPage");
        ReceiptResponseEB response = null;
        EBContext.initParameter();
        FEPAccess access = null;
        QueryReceiptResponse queryReceiptResponse = new QueryReceiptResponse();
        try {
            IReceipt receiptPageImpl = (IReceipt)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IReceipt.class, (Object)receiptRequest);
            if (receiptPageImpl.needLock()) {
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankVersionID());
                AccessUtils.checkQueryAllowed(context);
            }
            response = receiptPageImpl.queryReceipt(receiptRequest);
            queryReceiptResponse = ReceiptConvert.convert(response);
            QueryReceiptResponseBody body = queryReceiptResponse.getBody();
            body.setPageNum(response.getPageNum());
            body.setPageSize(response.getPageSize());
            body.setTotalCount(response.getTotalCount());
            body.setLastPage(response.isLastPage());
        }
        catch (Exception e) {
            try {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        return queryReceiptResponse;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "reconciliationPage";
    }
}

