/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.atom;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.parse.FileParserRegister;
import kd.ebg.receipt.common.framework.receipt.parse.api.IFileInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public interface IBankReceiptHandle
extends IBankServiceDesc,
IBankService<BankReceiptHandleRequest, BankReceiptHandleResponseEB, BankReceiptHandleRequest> {
    default public boolean isBreak() {
        return false;
    }

    default public String installReceiptJson(String fileName) {
        String bankVersion = EBContext.getContext().getBankVersionID();
        FileParserRegister fileParserRegister = (FileParserRegister)SpringContextUtil.getBean(FileParserRegister.class);
        IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersion, fileName);
        String trandDateStr = "";
        String accNo = "";
        String amount = iFileInfo.getAmount();
        String cdFlag = iFileInfo.getCdFlag();
        String receiptNo = iFileInfo.getReceiptNo();
        String oppAccNo = iFileInfo.getOppAccNo();
        if (EBGStringUtils.isEmpty((String)oppAccNo) || Objects.equals("null", oppAccNo)) {
            oppAccNo = "e";
        }
        if (EBGStringUtils.isEmpty((String)amount) || Objects.equals("null", amount)) {
            amount = "e";
        }
        if (EBGStringUtils.isEmpty((String)cdFlag) || Objects.equals("null", cdFlag)) {
            cdFlag = "e";
        }
        if (EBGStringUtils.isEmpty((String)receiptNo) || Objects.equals("null", receiptNo)) {
            receiptNo = "e";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[0], (Object)accNo);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], (Object)oppAccNo);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2], (Object)trandDateStr);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], (Object)amount);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], (Object)cdFlag);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5], (Object)receiptNo);
        return jsonObject.toJSONString();
    }

    default public Map<String, List<DownloadListDetail>> getGroupList(List<DownloadListDetail> downloadListDetails) {
        HashMap maps = Maps.newHashMapWithExpectedSize((int)1);
        String bankVersion = EBContext.getContext().getBankVersionID();
        FileParserRegister fileParserRegister = (FileParserRegister)SpringContextUtil.getBean(FileParserRegister.class);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            String accNo;
            String fileName = downloadListDetail.getFileName();
            IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersion, fileName);
            if (iFileInfo == null || !EBGStringUtils.isNotEmpty((String)(accNo = iFileInfo.getAccNo()))) continue;
            ArrayList<DownloadListDetail> details = maps.containsKey(accNo) ? (ArrayList<DownloadListDetail>)maps.get(accNo) : new ArrayList<DownloadListDetail>(1);
            details.add(downloadListDetail);
            maps.put(accNo, details);
        }
        return maps;
    }

    default public boolean isRemoveDetailBefore() {
        return false;
    }

    default public void init(BankReceiptHandleRequest request) {
    }
}

