/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.atom.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptDownload
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownload.class);

    @Override
    public String pack(BankReceiptRequest request) {
        Map<String, Object> paramMap = request.getParamsMap();
        String fileName = (String)paramMap.get("fileName");
        String frontProxyPath = (String)paramMap.get("frontProxyPath");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"content");
        jsonObject.put("path", (Object)frontProxyPath);
        jsonObject.put("name", (Object)fileName);
        String requestStr = jsonObject.toJSONString();
        logger.info("\u53d1\u9001\u7684\u4e0b\u8f7d\u8bf7\u6c42\uff1a{}" + requestStr);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        RequestContextUtils.setRunningParam((String)"charsetName", (String)EBContext.getContext().getCharsetName());
        EBContext.getContext().setCharsetName("UTF-8");
        return requestStr;
    }

    @Override
    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setCharsetName(RequestContextUtils.getRunningParam((String)"charsetName"));
        EBContext.getContext().setRemoveWriteResponseLog(false);
        Map<String, Object> paramMap = request.getParamsMap();
        String fileName = (String)paramMap.get("fileName");
        String bakFilePath = (String)paramMap.get("bakFilePath");
        try {
            String fileContent;
            if (StringUtils.isNotEmpty((String)responseStr) && responseStr.length() < 1000) {
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u6536\u5230\u7684\u4e0b\u8f7d\u54cd\u5e94\uff1a{}", new Object[]{fileName, responseStr.length()});
            }
            if (!EBGStringUtils.isEmpty((String)responseStr)) {
                JSONObject result = JSONObject.parseObject((String)(responseStr = new String(responseStr.getBytes("GBK"), "UTF-8")));
                fileContent = result.get((Object)"data").toString();
                if (EBGStringUtils.isEmpty((String)fileContent)) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e2d\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"BankReceiptDownload_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                }
                File receiptFilePath = FileCommonUtils.getFileByPath((String)bakFilePath);
                if (!receiptFilePath.exists()) {
                    receiptFilePath.mkdirs();
                }
            } else {
                throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"BankReceiptDownload_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
            }
            FileCommonUtils.base64ToFile((String)fileContent, (String)(bakFilePath + "/" + fileName));
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6" + fileName + "\u5931\u8d25\uff1a", (Throwable)e);
            throw new ReceiptException((Throwable)e);
        }
        return BankReceiptResponseEB.success();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "FRONT_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownload_2", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.setFrontProxyConnectFactory(factory);
    }
}

