/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.atom.impl;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class GetBankReceiptFileSize
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptFileSize.class);

    @Override
    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        Map<String, Object> paramMap = request.getParamsMap();
        String match = (String)paramMap.get("name");
        String frontProxyPath = (String)paramMap.get("frontProxyPath");
        String suffix = (String)paramMap.get("suffix");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"list");
        jsonObject.put("path", (Object)frontProxyPath);
        jsonObject.put("name", (Object)match);
        if (!EBGStringUtils.isEmpty((String)suffix)) {
            jsonObject.put("fileType", (Object)suffix);
        }
        String requestStr = jsonObject.toJSONString();
        logger.info("\u83b7\u53d6\u524d\u7f6e\u673a\u4e0a\u56de\u5355\u6587\u4ef6\u5927\u5c0f-{}-{}-\u8bf7\u6c42\u62a5\u6587\uff1a{}", new Object[]{accNo, transDate, requestStr});
        RequestContextUtils.setRunningParam((String)"charsetName", (String)EBContext.getContext().getCharsetName());
        EBContext.getContext().setCharsetName("UTF-8");
        return requestStr;
    }

    @Override
    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setCharsetName(RequestContextUtils.getRunningParam((String)"charsetName"));
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        logger.info("\u83b7\u53d6\u524d\u7f6e\u673a\u4e0a\u56de\u5355\u6587\u4ef6\u5927\u5c0f\u6536\u5230\u7684\u54cd\u5e94-{}-{}\uff1a{}", new Object[]{accNo, transDate, responseStr});
        if (!EBGStringUtils.isEmpty((String)responseStr)) {
            JSONObject result = JSONObject.parseObject((String)responseStr);
            return BankReceiptResponseEB.success(result.get((Object)"size").toString());
        }
        return BankReceiptResponseEB.fail(ResManager.loadKDString((String)"\u8bf7\u6c42\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5927\u5c0f\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"GetBankReceiptFileSize_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMD_DC_FRONT_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u524d\u7f6e\u673a\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5927\u5c0f\u3002", (String)"GetBankReceiptFileSize_1", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.setFrontProxyConnectFactory(factory);
    }
}

