/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.slf4j.MDC;

public class CreateTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CreateTask.class);
    private DownloadTaskService downloadTaskService;

    public CreateTask(ReceiptHandlerRequest request) {
        super(request);
    }

    @Override
    public boolean preTask() {
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(batchNo).bizName("receipt").logRequestSeqID(Sequence.genSequence()).build());
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        MDC.put((String)"bankVersion", (String)bankVersionId);
        EBContext.getContext().setType("create");
        return true;
    }

    @Override
    public boolean afterTask() {
        String transDateStr = this.receiptHandlerRequest.getTransDate();
        LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
        ReceiptCommonAipUtil.handleReceiptInfo((String)this.receiptHandlerRequest.getCustomId(), (String)this.receiptHandlerRequest.getBankVersion(), (String)this.receiptHandlerRequest.getBatchSeqId(), (LocalDate)transDate);
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        return true;
    }

    @Override
    public void subProcess() {
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String transDateStr = this.receiptHandlerRequest.getTransDate();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
        ReceiptCommonAipUtil receiptCommonAipUtil = new ReceiptCommonAipUtil();
        List bankAcntList = receiptCommonAipUtil.getNeedCreateTaskBankAcntList(bankVersionId, bankLoginId, transDate);
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u521b\u5efa\u56de\u5355\u4efb\u52a1 \u94f6\u884c\u8d26\u6237\u4e2a\u6570{}", (Object)bankAcntList.size());
        if (bankAcntList.isEmpty() || bankAcntList.size() == 0) {
            return;
        }
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(bankLoginId);
        bankLoginKey.setCustomId(customId);
        DynamicObject bankLogin = bankLoginRepository.findDynamicByIdAndCustomId(bankLoginKey);
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(bankVersionId);
        ArrayList<DynamicObject> newTaskList = new ArrayList<DynamicObject>(1);
        for (BankAcnt bankAcnt : bankAcntList) {
            String accNo = bankAcnt.getAccNo();
            DownloadListTask downLoadTask = new DownloadListTask();
            downLoadTask.setAccNo(accNo);
            downLoadTask.setBankLoginId(bankLoginId);
            downLoadTask.setBatchNo(batchNo);
            downLoadTask.setBankVersionId(bankVersionId);
            downLoadTask.setCustomNo(customId);
            downLoadTask.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
            downLoadTask.setTodaysFlag(this.receiptHandlerRequest.isToday() ? 1 : 0);
            downLoadTask.setTransDate(transDate);
            downLoadTask.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
            downLoadTask.setUploadNum(Integer.valueOf(0));
            downLoadTask.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            DynamicObject bankAcct = bankAcntRepository.findDataByAccNoAndCustomId(accNo, customId);
            Date date = LocalDateUtil.localDate2Date((LocalDate)downLoadTask.getTransDate());
            DynamicObject dynamicObject = this.buildReceiptTaskDynamicObject(bankVersion, bankLogin, bankAcct, batchNo, date, downLoadTask.getTodaysFlag());
            newTaskList.add(dynamicObject);
            this.logger.info("\u65b0\u589e\u4efb\u52a1 -> \u94f6\u884c:" + bankVersionId + "; \u8d26\u53f7:" + accNo + "; \u4ea4\u6613\u65e5\u671f:" + transDateStr);
        }
        if (!newTaskList.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newTaskList.get(0)).getDataEntityType(), (Object[])newTaskList.toArray());
        }
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u521b\u5efa\u56de\u5355\u4efb\u52a1");
    }

    @Override
    public boolean match() {
        return HandlerType.CREATE.getName().equals(this.receiptHandlerRequest.getType()) || HandlerType.TODAY_CREATE.getName().equals(this.receiptHandlerRequest.getType());
    }

    public DynamicObject buildReceiptTaskDynamicObject(DynamicObject bankVersion, DynamicObject bankLogin, DynamicObject accNo, String batchNo, Date transDate, int todaysFlag) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"receipt_download_task");
        dataEntity.set("bank_version", (Object)bankVersion);
        dataEntity.set("bank_login", (Object)bankLogin);
        dataEntity.set("acc_no", (Object)accNo);
        dataEntity.set("batch_no", (Object)batchNo);
        dataEntity.set("trans_date", (Object)transDate);
        Date date = new Date();
        dataEntity.set("createtime", (Object)date);
        dataEntity.set("modifytime", (Object)date);
        dataEntity.set("todays_flag", (Object)todaysFlag);
        dataEntity.set("status", (Object)TaskStatusEnum.CREATE.getId());
        dataEntity.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
        dataEntity.set("detail_flag", (Object)DetailDownloadStatusEnum.UN_DOWNLOAD.getId());
        dataEntity.set("custom_id", (Object)RequestContext.get().getTenantId());
        return dataEntity;
    }
}

