/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task.reconciliation;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.ReconciliationHandlerType;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.impl.task.reconciliation.ReconciliationUploadTask;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.log.MDCUtil;
import kd.ebg.receipt.common.framework.receipt.bank.BankBusinessProperties;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptExceptionUtil;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadListDetailService;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.DetailSyncRecord;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.common.utils.ofd.OfdSignUtil;
import org.slf4j.MDC;

public class DownLoadTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadTask.class);
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;
    private ReconciliationDownloadListDetailService reconciliationDownloadListDetailService;
    private DetailSyncRecordRepository detailSyncRecordRepository;

    public DownLoadTask(ReceiptHandlerRequest request) {
        super(request);
    }

    @Override
    public boolean preTask() {
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        this.reconciliationDownloadListDetailService = (ReconciliationDownloadListDetailService)SpringContextUtil.getBean(ReconciliationDownloadListDetailService.class);
        this.detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        long taskId = this.receiptHandlerRequest.getTaskId();
        String transDate = this.receiptHandlerRequest.getTransDate();
        String loggerBatchNo = Sequence.gen16Sequence();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(taskId + "").logRequestSeqID(taskId + "").bizName("reconciliation").bizSeqID(Sequence.gen18Sequence()).loggerBatchNo(taskId + "").loggerDetailNo(loggerBatchNo).loggerBankNo(ID.genLongId() + "").build());
        String accNo = this.receiptHandlerRequest.getAccNo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        EBContext.getContext().setBankAcnt(bankAcnt);
        MDC.put((String)"bankVersion", (String)bankVersionId);
        MDC.put((String)"transDate", (String)transDate);
        if (FileCommonUtils.isTestEnv()) {
            RequestContextUtils.setRunningParam((String)"timeout", (String)"3000");
        }
        EBContext.initParameter();
        MDCUtil.initMDC((EBContext)EBContext.getContext());
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u56de\u5355\u4e0b\u8f7d\u4e1a\u52a1\u5904\u7406,{}", (Object)loggerBatchNo);
        ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
        if (downloadListTask.getStatus().intValue() == TaskStatus.CREATE.getId()) {
            this.updateTaskStatus(downloadListTask, TaskStatus.PROCESSING.getId());
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.COMPLETED.getId()) {
            this.updateTaskStatus(downloadListTask, TaskStatus.DOWNLOADING.getId());
        }
        this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u5bf9\u8d26\u5355\u4efb\u52a1\u524d\u7f6e\u5904\u7406\u7ed3\u679c-{}-{}", new Object[]{downloadListTask.getAccNo(), downloadListTask.getId(), downloadListTask.getStatus()});
        return true;
    }

    @Override
    public boolean afterTask() {
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subProcess() {
        block13: {
            String bankVersionId = this.receiptHandlerRequest.getBankVersion();
            String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
            String transDateStr = this.receiptHandlerRequest.getTransDate();
            String accNo = this.receiptHandlerRequest.getAccNo();
            long taskId = this.receiptHandlerRequest.getTaskId();
            ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
            this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-taskId:{} \u8d26\u53f7\uff1a{} \u5bf9\u8d26\u5355\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDateStr});
            try {
                FEPAccess access = FEPAccessUtil.access((String)bankVersionId, (String)bankLoginId);
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                if (Objects.nonNull(access)) {
                    try {
                        this.doTask(downloadListTask);
                        break block13;
                    }
                    catch (Exception ex) {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\u56de\u6eda-taskId:{} \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f02\u5e38\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDateStr, ex.getMessage()});
                        this.logger.error("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)ex);
                        String message = ex.getMessage();
                        if (message.contains(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u73b0", (String)"DownLoadTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                            if (!EBGStringUtils.isEmpty((String)message) && message.length() > 190) {
                                message = message.substring(0, 190) + "...";
                            }
                            downloadListTask.setExpmsg(message);
                            this.updateTaskStatus(downloadListTask, TaskStatus.FAILED.getId());
                            return;
                        }
                        this.rollback(taskId, message);
                        break block13;
                    }
                    finally {
                        access.release();
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    }
                }
                throw new ReceiptException(ResManager.loadKDString((String)"\u201c\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1>\u5f53\u524d\u4efb\u52a1\u201d\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"DownLoadTask_13", (String)"ebg-receipt-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                String message = e.getMessage();
                if (message.contains(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u73b0", (String)"DownLoadTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    if (!EBGStringUtils.isEmpty((String)message) && message.length() > 200) {
                        message = message.substring(0, 200) + "...";
                    }
                    downloadListTask.setExpmsg(message);
                    this.updateTaskStatus(downloadListTask, TaskStatus.FAILED.getId());
                    return;
                }
                this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u5f02\u5e38\u56de\u6eda-taskId:{} \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f02\u5e38\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDateStr, e.getMessage()});
                this.logger.error("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u5f02\u5e38\u56de\u6eda\uff1a", e);
                this.rollback(taskId, message);
                this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-id:{}-\u8d26\u6237{}-\u65e5\u671f\uff1a{}-\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{taskId, accNo, transDateStr, e.getMessage()});
            }
        }
    }

    @Override
    public boolean match() {
        return ReconciliationHandlerType.DOWNLOAD.getName().equals(this.receiptHandlerRequest.getType());
    }

    public void updateTaskStatus(ReconciliationInfo task, Integer status) {
        task.setStatus(status);
        task.setCompleteTime(LocalDateTime.now());
        this.reconciliationDownloadTaskService.update(task);
    }

    public void rollback(long taskId, String message) {
        ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
        String accNo = downloadListTask.getAccNo();
        LocalDate transDate = downloadListTask.getTransDate();
        if (!EBGStringUtils.isEmpty((String)message) && message.length() > 190) {
            message = message.substring(0, 190) + "...";
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.PROCESSING.getId()) {
            downloadListTask.setExpmsg(message);
            this.updateTaskStatus(downloadListTask, TaskStatus.CREATE.getId());
            this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u521b\u5efa-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDate});
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.DOWNLOADING.getId()) {
            downloadListTask.setExpmsg(message);
            this.updateTaskStatus(downloadListTask, TaskStatus.COMPLETED.getId());
            this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u9884\u5904\u7406\u5b8c\u6210-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDate});
        }
    }

    public void doTask(ReconciliationInfo task) {
        this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u6267\u884c\u4e0b\u8f7d\u52a8\u4f5c\u4e4b\u524d\u5224\u65ad-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}-{}", new Object[]{task.getId(), task.getAccNo(), task.getTransDate(), task.getStatus()});
        if (task.getStatus().intValue() == TaskStatus.PROCESSING.getId()) {
            EBContext.getContext().setType("fetch");
            this.dealProcessingTask(task);
        }
        if (task.getStatus().intValue() == TaskStatus.DOWNLOADING.getId()) {
            EBContext.getContext().setType("download");
            this.dealDownloadingTask(task);
        }
    }

    public void dealXmlReceipt() {
    }

    private void dealProcessingTask(ReconciliationInfo task) {
        String accNo = task.getAccNo();
        String bankVersionId = task.getBankVersionId();
        String bankLoginId = task.getBankLoginId();
        LocalDate transDate = task.getTransDate();
        long taskId = task.getId();
        String customId = this.receiptHandlerRequest.getCustomId();
        try {
            List detailList = this.reconciliationDownloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
            ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
            BankReconciliationHandleRequest receiptRequest = BankReconciliationHandleRequest.builder().accNo(accNo).bankLoginId(bankLoginId).bankVersionId(bankVersionId).taskId(taskId).taskStatus(TaskStatus.PROCESSING.getId()).type(BankReceiptHandleRequest.TypeEnum.FETCH.name()).transDate(transDate).details(detailList).task(downloadListTask).build();
            IBankReconciliationHandle iBankReconciliation = (IBankReconciliationHandle)BankBundleManager.getInstance().getImpl(task.getBankVersionId(), IBankReconciliationHandle.class, (Object)receiptRequest);
            iBankReconciliation.init(receiptRequest);
            BankReconciliationHandleResponseEB receiptResponseEB = (BankReconciliationHandleResponseEB)iBankReconciliation.doBiz(receiptRequest);
            if (receiptResponseEB.getCode() == BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode()) {
                List details = (List)receiptResponseEB.getData();
                if (Objects.nonNull(details) && details.size() > 0) {
                    ArrayList<Long> detailIds = new ArrayList<Long>(16);
                    for (ReconciliationDetail detail : detailList) {
                        detailIds.add(detail.getId());
                    }
                    if (detailList.size() > 0) {
                        this.reconciliationDownloadListDetailService.deleteAll(detailIds);
                    }
                    ArrayList<ReconciliationDetail> insertList = new ArrayList<ReconciliationDetail>(details.size());
                    for (ReconciliationDetail detail : details) {
                        detail.setUploadRedo(0);
                        detail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                        detail.setExpmsg("");
                        detail.setUploadExpMsg("");
                        detail.setStatus(Integer.valueOf(TaskStatus.COMPLETED.getId()));
                        detail.setCompleteTime(LocalDateTime.now());
                        detail.setRefid(Long.valueOf(task.getId()));
                        detail.setTransDate(task.getTransDate());
                        detail.setAccNo(accNo);
                        detail.setBankLoginId(bankLoginId);
                        detail.setBankVersionId(bankVersionId);
                        detail.setCustomNo(customId);
                        detail.setRefid(Long.valueOf(taskId));
                        insertList.add(detail);
                    }
                    this.reconciliationDownloadListDetailService.saveAll(insertList);
                    task.setCompleteTime(LocalDateTime.now());
                    task.setRedo(Integer.valueOf(0));
                    if (iBankReconciliation.isBreak()) {
                        this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                    } else {
                        this.updateTaskStatus(task, TaskStatus.DOWNLOADING.getId());
                    }
                } else {
                    if (this.isNeedRetryDownload(task, ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4e0b\u8f7d\u5217\u8868\u4e3a\u7a7a\u3002", (String)"DownLoadTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                        return;
                    }
                    this.logger.info("\u83b7\u53d6\u7684\u4e0b\u8f7d\u5217\u8868\u4e3a\u7a7a\u3002");
                    task.setRedo(Integer.valueOf(task.getRedo() + 1));
                    task.setExpmsg(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4e0b\u8f7d\u5217\u8868\u4e3a\u7a7a\u3002", (String)"DownLoadTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    this.updateTaskStatus(task, TaskStatus.RETRYING.getId());
                }
            } else {
                String message = receiptResponseEB.getMessage();
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                task.setExpmsg(message);
                this.updateTaskStatus(task, TaskStatus.CREATE.getId());
                this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u83b7\u53d6\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u521b\u5efa-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}-\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDate, message});
            }
        }
        catch (Throwable e) {
            this.logger.info("\u6267\u884c\u83b7\u53d6\u5217\u8868\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002{}", (Object)e.getMessage());
            if (RetryErrorEnum.isNeedRetryByMsg((String)e.getMessage())) {
                task.setRedo(Integer.valueOf(0));
                task.setExpmsg(ReceiptExceptionUtil.formatException((Throwable)e, (int)255));
                task.setStatus(Integer.valueOf(TaskStatus.RETRYING.getId()));
                task.setCompleteTime(LocalDateTime.now());
                this.reconciliationDownloadTaskService.update(task);
            }
            if (this.isNeedRetryDownload(task, e.getMessage())) {
                return;
            }
            task.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
            task.setExpmsg(ReceiptExceptionUtil.formatException((Throwable)e, (int)255));
            this.reconciliationDownloadTaskService.update(task);
        }
    }

    private void dealDownloadingTask(ReconciliationInfo task) {
        String accNo = task.getAccNo();
        String bankVersionId = task.getBankVersionId();
        String bankLoginId = task.getBankLoginId();
        LocalDate transDate = task.getTransDate();
        long taskId = task.getId();
        String expMsg = "";
        int failedCount = 0;
        try {
            List detailList = this.reconciliationDownloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
            ReconciliationInfo downloadListTask = this.reconciliationDownloadTaskService.findById(taskId);
            BankReconciliationHandleRequest reconciliationRequest = BankReconciliationHandleRequest.builder().accNo(accNo).bankLoginId(bankLoginId).bankVersionId(bankVersionId).taskId(taskId).taskStatus(TaskStatus.DOWNLOADING.getId()).type(BankReceiptHandleRequest.TypeEnum.DOWNLOAD.name()).transDate(transDate).details(detailList).task(downloadListTask).build();
            IBankReconciliationHandle downloadHandle = (IBankReconciliationHandle)BankBundleManager.getInstance().getImpl(task.getBankVersionId(), IBankReconciliationHandle.class, (Object)reconciliationRequest);
            downloadHandle.init(reconciliationRequest);
            BankReconciliationHandleResponseEB reconciliationResponseEB = (BankReconciliationHandleResponseEB)downloadHandle.doBiz(reconciliationRequest);
            if (reconciliationResponseEB.getCode() == BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode()) {
                ArrayList<ReconciliationDetail> successOfDetails = (ArrayList<ReconciliationDetail>)reconciliationResponseEB.getData();
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-{}-{}-\u5bf9\u8d26\u5355\u6570\u91cf:{}", new Object[]{accNo, transDate, successOfDetails.size()});
                if (Objects.nonNull(successOfDetails) && successOfDetails.size() > 0) {
                    ArrayList zipFileIds = new ArrayList(detailList.size());
                    detailList.forEach(o -> {
                        if (o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".zip") || o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".rar") || o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".gz")) {
                            zipFileIds.add(o.getId());
                        }
                    });
                    String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
                    boolean isSupportPushAll = false;
                    int saveOfDataCount = detailList.size();
                    int successOfCount = successOfDetails.size();
                    if (zipFileIds.size() > 0) {
                        saveOfDataCount = successOfCount;
                        isSupportPushAll = true;
                    }
                    if (saveOfDataCount == successOfCount) {
                        if (saveOfDataCount > 0) {
                            ArrayList<ReconciliationDetail> checkedList = new ArrayList<ReconciliationDetail>(1);
                            for (ReconciliationDetail reconciliationDetail : successOfDetails) {
                                if (!OfdSignUtil.checkOFDFile((String)reconciliationDetail.getFileName(), (String)bakFilePath)) continue;
                                checkedList.add(reconciliationDetail);
                            }
                            successOfDetails = checkedList;
                        }
                        HashMap existDetailMap = Maps.newHashMapWithExpectedSize((int)detailList.size());
                        detailList.forEach(o -> existDetailMap.put(o.getFileName(), o));
                        ArrayList<ReconciliationDetail> updateDetailList = new ArrayList<ReconciliationDetail>(16);
                        ArrayList<ReconciliationDetail> insertDetailList = new ArrayList<ReconciliationDetail>(16);
                        for (ReconciliationDetail listDetail : successOfDetails) {
                            String fileName = listDetail.getFileName();
                            ReconciliationDetail downloadListDetail = (ReconciliationDetail)existDetailMap.get(fileName);
                            if (downloadListDetail == null) {
                                listDetail = this.installTaskDetailInfo(listDetail, bakFilePath, task);
                                insertDetailList.add(listDetail);
                                continue;
                            }
                            if ((downloadListDetail = this.installTaskDetailInfo(downloadListDetail, bakFilePath, task)).getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                                downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                            }
                            updateDetailList.add(downloadListDetail);
                        }
                        insertDetailList.forEach(o -> this.reconciliationDownloadListDetailService.save(o));
                        this.logger.info("\u5bf9\u8d26\u5355\u8be6\u60c5-\u65b0\u589e\u8bb0\u5f55--{}\uff0c\u66f4\u65b0\u6761\u6570\uff1a{}", new Object[]{insertDetailList.size(), updateDetailList.size()});
                        this.reconciliationDownloadListDetailService.updateAll(updateDetailList);
                        if (isSupportPushAll) {
                            this.reconciliationDownloadListDetailService.deleteAll(zipFileIds);
                        }
                        task.setExpmsg("");
                        task.setRedo(Integer.valueOf(0));
                        task.setReconciliationNum(successOfCount);
                        this.updateTaskStatus(task, TaskStatus.FINISH.getId());
                        this.upload(task);
                    } else {
                        this.logger.info("\u4e0b\u8f7d\u4efb\u52a1\uff1a" + task.getId() + "\u672a\u5b8c\u5168\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u8bbe\u7f6e\u91cd\u8bd5\u4e00\u6b21\u3002" + task.getAccNo() + "-" + task.getTransDate());
                        task.setExpmsg(String.format(ResManager.loadKDString((String)"\u5171\u8ba1%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c%2$s\u3002", (String)"DownLoadTask_16", (String)"ebg-receipt-business", (Object[])new Object[0]), failedCount, expMsg));
                        task.setRedo(Integer.valueOf(task.getRedo() + 1));
                        this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                    }
                } else {
                    this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-\u65e0\u5bf9\u8d26\u5355\u8bb0\u5f55-{}-{}", new Object[]{accNo, transDate});
                    if (this.isNeedRetryDownload(task, ResManager.loadKDString((String)"\u65e0\u5bf9\u8d26\u5355\u8bb0\u5f55", (String)"DownLoadTask_14", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                        return;
                    }
                    task.setRedo(Integer.valueOf(task.getRedo() + 1));
                    this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                }
            } else {
                this.logger.info("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-\u4e0b\u8f7d\u5931\u8d25-{}-{}", new Object[]{accNo, transDate});
                String message = reconciliationResponseEB.getMessage();
                task.setExpmsg(message);
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                this.logger.info("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u4efb\u52a1-\u83b7\u53d6\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u9884\u5904\u7406\u5b8c\u6210-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}-\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDate, message});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u53d1\u751f\u5f02\u5e38\u3002" + e.getMessage(), (Throwable)e);
            List details = this.reconciliationDownloadListDetailService.selectByRefId(Long.valueOf(taskId));
            for (ReconciliationDetail detail : details) {
                detail.setExpmsg(ReceiptExceptionUtil.formatException((Throwable)e, (int)255));
                detail.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                detail.setCompleteTime(LocalDateTime.now());
            }
            if (this.isNeedRetryDownload(task, e.getMessage())) {
                return;
            }
            this.reconciliationDownloadListDetailService.updateAll(details);
            task.setExpmsg(ReceiptExceptionUtil.formatException((Throwable)e, (int)255));
            task.setRedo(Integer.valueOf(task.getRedo() + 1));
            this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
        }
    }

    private boolean isNeedRetryDownload(ReconciliationInfo task, String message) {
        List detailSyncRecordList;
        int finalTotal;
        String bankVersionId = task.getBankVersionId();
        LocalDate transDate = task.getTransDate();
        String accNo = task.getAccNo();
        if (!RequestContextUtils.isSupportReconciliation((String)task.getBankLoginId())) {
            return false;
        }
        LocalDate endTransDate = transDate;
        if (RequestContextUtils.isMonthReconciliation()) {
            endTransDate = transDate.with(TemporalAdjusters.lastDayOfMonth());
        }
        if ((finalTotal = (detailSyncRecordList = this.detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDateBetween(task.getCustomNo(), accNo, transDate, endTransDate)).stream().mapToInt(DetailSyncRecord::getDetailCount).sum()) > 0) {
            BankBusinessProperties bankBusinessProperties = (BankBusinessProperties)EBConfigBuilder.getInstance().buildBusinessConfig(BankBusinessProperties.class, bankVersionId);
            String cacheName = task.getCustomNo() + task.getId() + "_Reconciliation";
            String cacheValue = CosmicCache.get((String)cacheName);
            if (RequestContextUtils.isReceiptAutoRetryDownload()) {
                if (StringUtils.isNotEmpty((String)cacheValue)) {
                    LocalDate lastDate = LocalDateUtil.parserDate((String)cacheValue);
                    if (lastDate.minusDays(-3L).isBefore(LocalDate.now())) {
                        return false;
                    }
                } else {
                    CosmicCache.putIfAbsentWithExpire((String)cacheName, (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()), (int)4, (TimeUnit)TimeUnit.DAYS);
                }
                task.setExpmsg(String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u53f7\u5b58\u5728\u4ea4\u6613\u6d41\u6c34\uff0c\u5bf9\u8d26\u5355\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6b63\u5728\u91cd\u65b0\u4e0b\u8f7d\u7535\u5b50\u5bf9\u8d26\u5355\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"DownLoadTask_20", (String)"ebg-receipt-business", (Object[])new Object[0]), message));
                task.setExpmsg(DownLoadTask.formatException(task.getExpmsg(), 255));
                task.setRedo(Integer.valueOf(0));
                this.updateTaskStatus(task, TaskStatus.RETRYING.getId());
                this.logger.info("\u5b58\u5728\u6d41\u6c34\uff0c\u5bf9\u8d26\u5355\u4efb\u52a1\u81ea\u52a8\u91cd\u65b0\u4e0b\u8f7d-{}-{}-\u4ea4\u6613\u660e\u7ec6\u6570-{}", new Object[]{accNo, transDate, finalTotal});
                return true;
            }
        }
        return false;
    }

    public static String formatException(String message, int length) {
        if (EBGStringUtils.isNotEmpty((String)message)) {
            if (message.length() > length) {
                message = message.substring(0, length);
            }
        } else {
            message = "";
        }
        return message;
    }

    private ReconciliationDetail installTaskDetailInfo(ReconciliationDetail downloadListDetail, String bakFilePath, ReconciliationInfo task) {
        downloadListDetail.setStatus(Integer.valueOf(TaskStatus.FINISH.getId()));
        downloadListDetail.setCompleteTime(LocalDateTime.now());
        downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
        if (StringUtils.isEmpty((String)downloadListDetail.getBankFilePath())) {
            downloadListDetail.setBankFilePath(bakFilePath + File.separator + downloadListDetail.getFileName());
        }
        downloadListDetail.setExpmsg("");
        downloadListDetail.setUploadRedo(0);
        downloadListDetail.setUploadExpMsg("");
        downloadListDetail.setRefid(Long.valueOf(task.getId()));
        downloadListDetail.setTransDate(task.getTransDate());
        downloadListDetail.setAccNo(task.getAccNo());
        downloadListDetail.setBankLoginId(task.getBankLoginId());
        downloadListDetail.setBankVersionId(task.getBankVersionId());
        downloadListDetail.setCustomNo(task.getCustomNo());
        downloadListDetail.setRefid(Long.valueOf(task.getId()));
        return downloadListDetail;
    }

    public void upload(ReconciliationInfo downloadListTask) {
        String bankVersionId = downloadListTask.getBankVersionId();
        ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
        receiptRequest.setBankVersion(downloadListTask.getBankVersionId());
        receiptRequest.setType(HandlerType.UPLOAD.getName());
        receiptRequest.setBankLoginId(downloadListTask.getBankLoginId());
        receiptRequest.setCustomId(downloadListTask.getCustomNo());
        receiptRequest.setAccNo(downloadListTask.getAccNo());
        receiptRequest.setTaskId(downloadListTask.getId());
        receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
        this.logger.info("\u5bf9\u8d26\u5355\u4efb\u52a1-\u5c06\u4efb\u52a1ID:{}-\u94f6\u884c\u7248\u672c\uff1a{}-\u8d26\u53f7\uff1a{}-\u4e0b\u8f7d\u5b8c\u6210\u7acb\u523b\u8fdb\u884c\u6587\u4ef6\u4e0a\u4f20", new Object[]{downloadListTask.getId(), bankVersionId, downloadListTask.getAccNo()});
        ReconciliationUploadTask uploadTask = new ReconciliationUploadTask(receiptRequest);
        if (uploadTask.preTask()) {
            uploadTask.subProcess();
            EBContext ebContext = EBContext.getContext();
            uploadTask.afterTask();
            EBContext.setContext((EBContext)ebContext);
        }
    }
}

