/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.query.IReceiptPage;
import kd.ebg.receipt.business.receipt.query.ReceiptResult;
import kd.ebg.receipt.business.receipt.query.ReceiptResultPage;
import kd.ebg.receipt.business.receipt.query.Result;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class FileReceiptPage
implements IReceiptPage {
    private DownloadListDetailRepository downloadListDetailRepository;
    private DownloadTaskService downloadTaskService;

    @Override
    public String getFirstPageTag() {
        return "1";
    }

    @Override
    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    @Override
    public boolean isLastPage(String rspStr, String pageTag) {
        Result resultSet = (Result)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Result<ReceiptResultPage>>(){}, (Feature[])new Feature[0]);
        if (!"success".equals(resultSet.getCode())) {
            return true;
        }
        return ((ReceiptResultPage)resultSet.getData()).isLastPage();
    }

    public ReceiptResponseEB doBiz(ReceiptRequest request) {
        int pageSize;
        this.downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        String accNo = request.getAccNo();
        String bankVersionID = request.getHeader().getBankVersionID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String customID = EBContext.getContext().getCustomID();
        ArrayList details = new ArrayList(16);
        String fixedAccNo = accNo;
        int page = request.getPageNum();
        if (page <= 0) {
            page = 1;
        }
        if ((pageSize = request.getPageSize()) <= 0) {
            pageSize = 1000;
        }
        List downloadListTasks = this.downloadTaskService.findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(bankVersionID, customID, startDate, endDate);
        HashMap transDateMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<Long> refIDs = new ArrayList<Long>(16);
        for (DownloadListTask info : downloadListTasks) {
            ReceiptResult result = new ReceiptResult();
            result.setCompleteFlas(1);
            result.setTransDate(info.getTransDate());
            result.setRefID(info.getId());
            refIDs.add(info.getId());
            transDateMap.put(info.getId(), info.getTransDate());
        }
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "id")});
        PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)pageSize, (Sort)sort);
        Page detailPage = this.downloadListDetailRepository.findByRefidInAndAccNoPage(refIDs, fixedAccNo, (Pageable)pageRequest);
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        if (detailPage.getContent() != null) {
            details.addAll(detailPage.getContent());
        }
        long totalElements = detailPage.getTotalElements();
        int totalPages = detailPage.getTotalPages();
        boolean lastPage = detailPage.isLast();
        for (DownloadListDetail detail : details) {
            if (!this.isValid(detail.getDetailNo())) continue;
            detailList.add(detail);
        }
        ArrayList<DownloadListDetail> newDetailList = new ArrayList<DownloadListDetail>(16);
        newDetailList.addAll(detailList);
        detailList.clear();
        detailList.addAll(this.removeRepeat(newDetailList));
        ArrayList<ReceiptInfo> bankReceiptInfos = new ArrayList<ReceiptInfo>(16);
        boolean isFileReceipt = RequestContextUtils.receiptFormatIsFile();
        if (Objects.nonNull(newDetailList)) {
            for (DownloadListDetail detail : details) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                ReceiptInfo info = new ReceiptInfo();
                if (isFileReceipt) {
                    info.setReceiptNo(detail.getDetailNo());
                    info.setFilePath(detail.getBankFilePath());
                    info.setTransDate(((LocalDate)transDateMap.get(detail.getRefid())).format(DateTimeFormatter.BASIC_ISO_DATE));
                    info.setAccNo(request.getAccNo());
                    info.setAccName(EBContext.getContext().getBankAcnt().getAccName());
                    info.setBankName(EBContext.getContext().getBankAcnt().getBankName());
                    info.setExplanation(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u7684\u56de\u5355\uff0c\u8bf7\u67e5\u9605\u56de\u5355\u6587\u4ef6\u5185\u5bb9\u3002", (String)"FileReceiptPage_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    info.setBankName(detail.getBankName());
                    info.setOppAccNo(detail.getOppAccNo());
                    info.setOppAccName(detail.getOppAccName());
                    info.setDebitAmount(detail.getDebitAmount());
                    info.setCreditAmount(detail.getCreditAmount());
                    info.setCurrency(detail.getCurrency());
                    info.setUseCn(detail.getUseCN());
                    String uploadFileName = detail.getUploadFileName();
                    if (!EBGStringUtils.isEmpty((String)uploadFileName)) {
                        info.setUploadFileName(uploadFileName);
                    }
                    info.setUploadFlag(detail.getUploadFlag());
                } else {
                    info = (ReceiptInfo)JSONObject.parseObject((String)detail.getOfdJson(), ReceiptInfo.class);
                }
                bankReceiptInfos.add(info);
            }
        }
        responseEB.setReceiptInfos(bankReceiptInfos);
        responseEB.setTcpUrl("");
        responseEB.setFileServerUrl("");
        responseEB.setUserName("");
        if (isFileReceipt) {
            responseEB.setFileFlag(1);
        } else {
            responseEB.setFileFlag(0);
        }
        responseEB.setCompleteFlag(1);
        responseEB.setUserName("");
        responseEB.setPageNum(page);
        responseEB.setPageSize(pageSize);
        responseEB.setTotalCount(totalElements);
        responseEB.setLastPage(lastPage);
        return responseEB;
    }

    public List<DownloadListDetail> removeRepeat(List<DownloadListDetail> receiptDetails) {
        ArrayList<DownloadListDetail> newReceiptDatails = new ArrayList<DownloadListDetail>(16);
        newReceiptDatails.addAll(receiptDetails);
        ArrayList<String> detailNoList = new ArrayList<String>(16);
        for (DownloadListDetail receiptDetail : receiptDetails) {
            if (detailNoList.contains(receiptDetail.getDetailNo())) {
                newReceiptDatails.remove(receiptDetail);
                continue;
            }
            detailNoList.add(receiptDetail.getDetailNo());
        }
        return newReceiptDatails;
    }

    private boolean isValid(String detailNo) {
        if (detailNo.trim().endsWith("_") || detailNo.trim().startsWith("_")) {
            return false;
        }
        int count = 0;
        String str = detailNo;
        int index = 0;
        while ((index = str.indexOf("_")) != -1) {
            str = str.substring(index + 1);
            ++count;
        }
        String[] params = detailNo.split("_");
        return params.length == count + 1;
    }
}

