/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.query.balanceReconciliation;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.business.receipt.atom.IBalanceReconciliationQuery;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryRequest;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryResponseEB;
import kd.ebg.receipt.business.receipt.query.ReceiptResult;
import kd.ebg.receipt.business.receipt.query.balanceReconciliation.FileBalanceReconciliationQueryPage;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.BalanceReconciliationDetail;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class FileBalanceReconciliationQueryImpl
implements IBalanceReconciliationQuery {
    private ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository;
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;

    @Override
    public boolean needLock() {
        return false;
    }

    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return "EBGFileReceipt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u94f6\u4f01\u5e73\u53f0\u56de\u5355\u7a0b\u5e8f\u83b7\u53d6\u6587\u4ef6\u56de\u5355\u7d22\u5f15\u3002", (String)"FileBalanceReconciliationQueryImpl_0", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public BalanceReconciliationQueryResponseEB doBiz(BalanceReconciliationQueryRequest request) {
        if ("balanceReconciliationQueryPage".equals(request.getHeader().getSubBizType())) {
            return new FileBalanceReconciliationQueryPage().doBiz(request);
        }
        BalanceReconciliationQueryResponseEB responseEB = new BalanceReconciliationQueryResponseEB();
        this.reconciliationDownloadListDetailRepository = (ReconciliationDownloadListDetailRepository)SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class);
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        String accNo = request.getAccNo();
        String bankVersionID = request.getHeader().getBankVersionID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String customID = EBContext.getContext().getCustomID();
        String fixedAccNo = accNo;
        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersionID)) {
            fixedAccNo = "";
        }
        String reconciliationProtocolNo = request.getReconciliationProtocolNo();
        List downloadListTasks = this.reconciliationDownloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(fixedAccNo, bankVersionID, null, startDate, endDate);
        List detailList = new ArrayList(16);
        ArrayList<Long> refIDs = new ArrayList<Long>(16);
        for (ReconciliationInfo info : downloadListTasks) {
            ReceiptResult result = new ReceiptResult();
            result.setCompleteFlas(1);
            result.setTransDate(info.getTransDate());
            result.setRefID(info.getId());
            refIDs.add(info.getId());
        }
        detailList = this.reconciliationDownloadListDetailRepository.findByRefidsAndProtocolNo(refIDs, reconciliationProtocolNo);
        ArrayList<BalanceReconciliationDetail> bankReceiptInfos = new ArrayList<BalanceReconciliationDetail>(16);
        if (detailList.size() > 0) {
            for (ReconciliationDetail detail : detailList) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                BalanceReconciliationDetail info = new BalanceReconciliationDetail();
                info.setFilePath(detail.getBankFilePath());
                info.setAccNo(fixedAccNo);
                info.setReconciliationNo(detail.getReconciliationNo());
                info.setReconciliationProtocolNo(detail.getReconciliationProtocolNo());
                info.setReconciliationYearMonth(detail.getYearMonth());
                info.setExplanation(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u7684\u5bf9\u8d26\u5355\uff0c\u8bf7\u67e5\u9605\u5bf9\u8d26\u5355\u6587\u4ef6\u5185\u5bb9\u3002", (String)"FileBalanceReconciliationQueryImpl_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
                String uploadFileName = detail.getUploadFileName();
                if (!EBGStringUtils.isEmpty((String)uploadFileName)) {
                    info.setUploadFileName(uploadFileName);
                }
                info.setUploadFlag(detail.getUploadFlag().intValue());
                bankReceiptInfos.add(info);
            }
        }
        responseEB.setDetails(bankReceiptInfos);
        responseEB.setFileFlag(1);
        responseEB.setTotalCount(bankReceiptInfos.size());
        responseEB.setCompleteFlag(1);
        return responseEB;
    }

    public boolean match(BalanceReconciliationQueryRequest receiptRequest) {
        boolean result = "balanceReconciliationQuery".equalsIgnoreCase(receiptRequest.getHeader().getBizType());
        return result;
    }
}

