/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.schedule;

import java.util.Map;
import java.util.Stack;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.impl.handler.CreateTaskHandler;
import kd.ebg.receipt.business.receipt.impl.handler.DownLoadTaskHandler;
import kd.ebg.receipt.business.receipt.impl.handler.IntegrityHandler;
import kd.ebg.receipt.business.receipt.impl.handler.MatchHandler;
import kd.ebg.receipt.business.receipt.impl.handler.RetryHandler;
import kd.ebg.receipt.business.receipt.impl.handler.TaskStatusHandler;
import kd.ebg.receipt.common.framework.properties.SystemPropertyConfig;

public class TodayReceiptScheduleJob
extends AbstractTask {
    public static ScheduleHanlder hanlder;
    private static final EBGLogger logger;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isPaymentAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            logger.info("\u975e\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u56de\u5355\u67e5\u8be2\u4e0e\u4e0b\u8f7d");
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("\u56de\u5355\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        if (hanlder == null) {
            hanlder = this.init();
        }
        hanlder.process();
        long end = System.currentTimeMillis();
        logger.info("\u56de\u5355\u8c03\u5ea6\u4efb\u52a1\u7ed3\u675f,\u7528\u65f6\uff1a{}\u6beb\u79d2", (Object)(end - start));
    }

    public ScheduleHanlder init() {
        Stack<ScheduleHanlder> scheduleHanlderStack = new Stack<ScheduleHanlder>();
        CreateTaskHandler createTaskHandler = new CreateTaskHandler(HandlerType.TODAY_CREATE.getName());
        scheduleHanlderStack.push(createTaskHandler);
        TaskStatusHandler taskStatusHandler = new TaskStatusHandler(HandlerType.STATUS.getName());
        scheduleHanlderStack.push(taskStatusHandler);
        DownLoadTaskHandler downLoadTaskHandler = new DownLoadTaskHandler(HandlerType.TODAY_DOWNLOAD.getName());
        scheduleHanlderStack.push(downLoadTaskHandler);
        IntegrityHandler integrityHandler = new IntegrityHandler(HandlerType.INTEGRITY.getName());
        scheduleHanlderStack.push(integrityHandler);
        MatchHandler matchHandler = new MatchHandler(HandlerType.MATCH.getName());
        scheduleHanlderStack.push(matchHandler);
        RetryHandler retryHandler = new RetryHandler(HandlerType.RETRY.getName());
        scheduleHanlderStack.push(retryHandler);
        ScheduleHanlder hanlder = null;
        ScheduleHanlder nextHanlder = null;
        while (!scheduleHanlderStack.empty()) {
            hanlder = (ScheduleHanlder)scheduleHanlderStack.pop();
            hanlder.setNextHandler(nextHanlder);
            nextHanlder = hanlder;
        }
        return hanlder;
    }

    static {
        logger = EBGLogger.getInstance().getLogger(TodayReceiptScheduleJob.class);
    }
}

