/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.impl.BankReceiptDownload;
import kd.ebg.receipt.business.receipt.atom.impl.GetBankReceiptFileList;
import kd.ebg.receipt.business.receipt.atom.impl.GetBankReceiptFileSize;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;

public class BankReceiptApiUtil {
    private String accNo;
    private LocalDate transDate;

    public BankReceiptApiUtil(String accNo, LocalDate transDate) {
        this.accNo = accNo;
        this.transDate = transDate;
    }

    public boolean downloadReceiptFile(String fileName) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)this.accNo, (String)LocalDateUtil.formatDate((LocalDate)this.transDate));
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("fileName", fileName);
        paramsMap.put("bakFilePath", bakFilePath);
        String frontProxyPath = bankFtpProperties.getFrontProxyPath();
        if (Objects.equals(bankVersionId, "CEB_DC")) {
            frontProxyPath = frontProxyPath + File.separator + this.transDate;
        }
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        BankReceiptDownload iBankReceipt = new BankReceiptDownload();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        return receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode();
    }

    public boolean downloadReceiptFileWithPath(String ftpPath, String fileName, String savePath) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("fileName", fileName);
        paramsMap.put("bakFilePath", savePath);
        paramsMap.put("frontProxyPath", ftpPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        BankReceiptDownload iBankReceipt = new BankReceiptDownload();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        return receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode();
    }

    public boolean downloadReceiptFile(String fileName, String savePath) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        String bankLogin = EBContext.getContext().getBankLoginID();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("fileName", fileName);
        paramsMap.put("bakFilePath", savePath);
        String frontProxyPath = bankFtpProperties.getFrontProxyPath();
        if (Objects.equals(bankVersionId, "CEB_DC")) {
            frontProxyPath = frontProxyPath + File.separator + this.transDate;
        }
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        BankReceiptDownload iBankReceipt = new BankReceiptDownload();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        return receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode();
    }

    public List<String> getFileByName(String matchString) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bankVersion = EBContext.getContext().getBankVersionID();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String frontProxyPath = bankFtpProperties.getFrontProxyPath();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("name", matchString);
        if (Objects.equals(bankVersion, "CEB_DC")) {
            frontProxyPath = frontProxyPath + File.separator + this.transDate;
        }
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        GetBankReceiptFileList iBankReceipt = new GetBankReceiptFileList();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            return (List)receiptResponseEB.getData();
        }
        return new ArrayList<String>(16);
    }

    public List<String> getFileByName(String matchString, String suffix) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bankVersion = EBContext.getContext().getBankVersionID();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String frontProxyPath = bankFtpProperties.getFrontProxyPath();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("name", matchString);
        if (Objects.equals(bankVersion, "CEB_DC")) {
            frontProxyPath = frontProxyPath + File.separator + this.transDate;
        }
        if (!EBGStringUtils.isEmpty((String)suffix)) {
            paramsMap.put("suffix", suffix);
        }
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        GetBankReceiptFileList iBankReceipt = new GetBankReceiptFileList();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            return (List)receiptResponseEB.getData();
        }
        return new ArrayList<String>(16);
    }

    public List<String> getFileByName(String matchString, String suffix, String frontProxyPath) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("name", matchString);
        if (!EBGStringUtils.isEmpty((String)suffix)) {
            paramsMap.put("suffix", suffix);
        }
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        GetBankReceiptFileList iBankReceipt = new GetBankReceiptFileList();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            return (List)receiptResponseEB.getData();
        }
        return new ArrayList<String>(16);
    }

    public long getFileSize(String matchString) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String frontProxyPath = bankFtpProperties.getFrontProxyPath();
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
        paramsMap.put("name", matchString);
        paramsMap.put("frontProxyPath", frontProxyPath);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(this.accNo).transDate(this.transDate).paramsMap(paramsMap).build();
        GetBankReceiptFileSize iBankReceipt = new GetBankReceiptFileSize();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz(request);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            return Long.parseLong((String)receiptResponseEB.getData());
        }
        return 0L;
    }
}

