/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.receipt.ReceiptJson;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptTaskHandleUtils {
    private EBCReceiptInfoJsonService ebcReceiptInfoJsonService;
    private static ReceiptTaskHandleUtils instance;

    public static synchronized ReceiptTaskHandleUtils getInstance() {
        if (instance == null) {
            instance = new ReceiptTaskHandleUtils();
        }
        instance.init();
        return instance;
    }

    public void init() {
        this.ebcReceiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public void handReceiptJsonRecord(List<DownloadListDetail> downloadListDetailList) {
        List jsonIds = downloadListDetailList.stream().filter(downloadListDetail -> EBGStringUtils.isNotEmpty((String)downloadListDetail.getReceiptJson())).map(o -> Long.toString(o.getId())).collect(Collectors.toList());
        this.ebcReceiptInfoJsonService.deleteBatchByDetailId(jsonIds);
        ArrayList<ReceiptJson> receiptJsons = new ArrayList<ReceiptJson>(1);
        for (DownloadListDetail downloadListDetail2 : downloadListDetailList) {
            ReceiptJson receiptJson = new ReceiptJson();
            receiptJson.setJson(downloadListDetail2.getReceiptJson());
            receiptJson.setReceiptDetailId(downloadListDetail2.getId() + "");
            receiptJson.setCreatetime(LocalDateTime.now());
            receiptJson.setCustomNo(downloadListDetail2.getCustomNo());
            receiptJsons.add(receiptJson);
        }
        this.ebcReceiptInfoJsonService.saveAll(receiptJsons);
    }

    public void handReceiptJsonRecordOnDownload(List<DownloadListDetail> listDetailsByDB, List<DownloadListDetail> listDetailsByDownload) {
        Map<String, DownloadListDetail> downloadListDetailMap = listDetailsByDownload.stream().collect(Collectors.toMap(item -> item.getDetailNo(), item -> item));
        ArrayList<DownloadListDetail> handleList = new ArrayList<DownloadListDetail>(1);
        for (DownloadListDetail downloadListDetail : listDetailsByDB) {
            DownloadListDetail detail;
            if (!EBGStringUtils.isNotEmpty((String)downloadListDetail.getDetailNo()) || !downloadListDetailMap.containsKey(downloadListDetail.getDetailNo()) || (detail = downloadListDetailMap.get(downloadListDetail.getDetailNo())) == null || !EBGStringUtils.isNotEmpty((String)detail.getReceiptJson())) continue;
            downloadListDetail.setReceiptJson(detail.getReceiptJson());
            handleList.add(downloadListDetail);
        }
        this.handReceiptJsonRecord(handleList);
    }

    public List<DownloadListTask> sortDescTaskListBySort(List<DownloadListTask> downloadListTasks) {
        return downloadListTasks.stream().sorted(Comparator.comparing(DownloadListTask::getSort).reversed()).collect(Collectors.toList());
    }
}

