/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.dlb.dc.service.receipt.util;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.dlb.dc.service.receipt.DlbDcCommonConfig;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import org.jdom2.Element;

public class ReceiptPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPacker.class);

    public static String detailtPack(DownloadListTask task) {
        String tr_code = "416B200110A";
        DlbDcCommonConfig config = (DlbDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(DlbDcCommonConfig.class, task.getBankLoginId());
        String acno = task.getAccNo();
        String start_date = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String end_date = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String cms_corp_no = config.getCms_corp_no();
        Element root = JDomExtUtils.createRoot((String)"ap");
        JDomUtils.addChild((Element)root, (Element)ReceiptPacker.headPack(tr_code, "0"));
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)"01");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acno);
        JDomUtils.addChild((Element)body, (String)"start_date", (String)start_date);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)end_date);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        String request = null;
        try {
            request = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)"GBK");
        }
        catch (Exception e) {
            throw new ReceiptException(ResManager.loadKDString((String)"root\u8f6c\u6362\u6210String\u5f02\u5e38\uff1b", (String)"ReceiptPacker_0", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        request = request.replace("<?xml version=\"1.0\" encoding=\"GBK\"?>", "");
        return ReceiptPacker.xmlHead(request) + "00" + request;
    }

    public static String receiptPack(DownloadListTask task, String host_serial_no) {
        String tr_code = "416B3012";
        String acno = task.getAccNo();
        String tr_acdt = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        Element root = JDomExtUtils.createRoot((String)"ap");
        JDomUtils.addChild((Element)root, (Element)ReceiptPacker.headPack(tr_code, "1"));
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)tr_acdt);
        JDomUtils.addChild((Element)body, (String)"acno", (String)acno);
        JDomUtils.addChild((Element)body, (String)"host_serial_no", (String)host_serial_no);
        String request = null;
        try {
            request = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)"GBK");
        }
        catch (Exception e) {
            throw new ReceiptException(ResManager.loadKDString((String)"root\u8f6c\u6362\u6210String\u5f02\u5e38\uff1b", (String)"ReceiptPacker_0", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        request = request.replace("<?xml version=\"1.0\" encoding=\"GBK\"?>", "");
        return ReceiptPacker.xmlHead(request) + "00" + request;
    }

    public static Element headPack(String tr_code, String file_flag) {
        String randomNum = (Sequence.gen16NumSequence() + "").substring(0, 3);
        String localTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        String req_no = randomNum + localTime;
        String tr_acdt = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String tr_time = LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)tr_acdt);
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)tr_time);
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)file_flag);
        JDomUtils.addChild((Element)head, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)head, (String)"Reserved", (String)"");
        return head;
    }

    public static String xmlHead(String request) {
        String msgLen;
        String requestLen = msgLen = String.valueOf(request.getBytes(StandardCharsets.UTF_8).length + 2);
        try {
            for (int i = 0; i < 10 - msgLen.length(); ++i) {
                requestLen = "0" + requestLen;
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return requestLen;
    }
}

