/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.dlb.dc.service.receipt.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class SocketSender {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SocketSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequestBySocket(String request, String bankLogin) {
        Socket client = null;
        InputStreamReader streamReader = null;
        BufferedReader reader = null;
        PrintWriter printWriter = null;
        StringBuilder result = new StringBuilder();
        try {
            String info;
            BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLogin);
            String ip = loginProperties.getIp();
            int port = loginProperties.getPort();
            client = new Socket(ip, port);
            client.setSoTimeout(18000);
            printWriter = new PrintWriter(client.getOutputStream());
            printWriter.println(request);
            printWriter.flush();
            streamReader = new InputStreamReader(client.getInputStream());
            reader = new BufferedReader(streamReader);
            while ((info = reader.readLine()) != null) {
                result.append(info);
            }
        }
        catch (Exception e) {
            log.info("\u5927\u8fde\u94f6\u884c\u901a\u8fc7Socket\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u7ed3\u679c\u5f02\u5e38");
            log.info(e.getMessage());
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
                if (streamReader != null) {
                    streamReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception ex) {
                log.info(ex.getMessage());
            }
        }
        return result.toString();
    }
}

