/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.cmp.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        String bankLogin = request.getBankLoginId();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (this.download(downloadListDetail, bakFilePath, accNo, transDate, bankFtpProperties, sftp)) {
                logger.info("\u4e0b\u8f7d\u6210\u529f\uff0c\u6587\u4ef6\u540d\u4e3a{}", (Object)downloadListDetail.getFileName());
                continue;
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]));
        }
        logger.info(">>>>>>>>>\u957f\u6c99\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String fileName = detail.getFileLink();
        logger.info("\u4e0b\u8f7d\u7684\u539f\u6587\u4ef6\u540d{}", (Object)fileName);
        String[] fileNameSplit = fileName.split("/");
        String dir = fileNameSplit[0];
        logger.info("\u76ee\u5f55{}", (Object)dir);
        String fn = fileNameSplit[1];
        logger.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d{}", (Object)fn);
        try {
            boolean flag = false;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftpPath = bankFtpProperties.getFtpPath();
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath + "/" + dir, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                String frontProxyPath = bankFtpProperties.getFrontProxyPath();
                flag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath + File.separator + dir, fn, bakFilePath);
            }
            if (flag) {
                logger.info("\u4e0b\u8f7d\u6210\u529f");
                File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fn));
                logger.info("\u6587\u4ef6\u5b58\u5728\uff1a{}", (Object)file.exists());
                FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
            }
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

