/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.cmp.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.bcs.cmp.service.receipt.HisReceiptDownloadImpl;
import kd.ebg.receipt.banks.bcs.cmp.service.receipt.HisReceiptInfoQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private static final String RECEIPTSEPERATOR = "_";

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(8);
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr("1").build();
        List<String> info = new HisReceiptInfoQueryImpl().process(req);
        for (String x : info) {
            BankReceiptRequest downloadReq = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(x).build();
            BankReceiptResponseEB resp = new HisReceiptDownloadImpl().doBiz(downloadReq);
            Map data = (Map)resp.getData();
            String lsh = (String)data.get("lsh");
            String filename = (String)data.get("filename");
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileName(this.newFileName(accNo, transDateStr, lsh));
            detail.setFileLink(filename);
            result.add(detail);
        }
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDateStr + "\n");
        logger.info(">>>>>>>>>\u957f\u6c99\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]);
    }

    public String newFileName(String ... args) {
        return String.join((CharSequence)RECEIPTSEPERATOR, args) + ".pdf";
    }
}

