/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.cmp.service.utils;

import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static Element buildHead(String trsCode, String seqNo) {
        return Packer.buildHead(trsCode, seqNo, "0", "0");
    }

    public static Element buildHead(String trsCode, String seqNo, String sign, String fileFlag) {
        Element root = new Element("ap");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)trsCode);
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_id", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)seqNo);
        Date now = new Date();
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)DateUtil.formatDate((Date)now, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)DateUtil.formatDate((Date)now, (String)"HHmmss"));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)sign);
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)fileFlag);
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        JDomUtils.addChild((Element)head, (String)"session_id", (String)"");
        JDomUtils.addChild((Element)head, (String)"local_ip", (String)"");
        JDomUtils.addChild((Element)head, (String)"mac_addr", (String)"");
        JDomUtils.addChild((Element)head, (String)"internet_ip", (String)"");
        JDomUtils.addChild((Element)root, (String)"body");
        return root;
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = Packer.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        buffer.append(Packer.formatLen(Integer.toString(length + 2), 10));
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String formatLen(String orgStr, int expectedLength) {
        try {
            String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
            return StringFormater.formatLen((String)orgStr, (int)expectedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public static int getLength(String msg) {
        String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
        try {
            return msg.getBytes(encoding).length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }
}

