/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.glb.dc.service.receipt.api;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.glb.dc.service.util.GLBPacker;
import kd.ebg.receipt.banks.glb.dc.service.util.GLBStringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String FORMAT = "yyyyMMdd";

    public String pack(BankReceiptRequest request) {
        LocalDate transDate = request.getTransDate();
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"accountNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)transDate.format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)transDate.format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)body, (String)"turnPageNum", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"turnPageShowNum", (String)String.valueOf(100));
        JDomUtils.addChild((Element)body, (String)"querySort", (String)"0");
        JDomUtils.addChild((Element)body, (String)"queryFlag", (String)"01");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element listElement;
        List list;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ebenk.getChild("head");
        if (!"000000".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-glb-dc", (Object[])new Object[0]), head.getChildText("retMessage"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        this.setLastPage(true);
        Element body = ebenk.getChild("body");
        String turnPageTotalNum = body.getChildText("turnPageTotalNum");
        int total = 0;
        if (EBGStringUtils.isNotEmpty((String)turnPageTotalNum)) {
            total = Integer.parseInt(turnPageTotalNum);
        }
        if ((list = (listElement = body.getChild("list")).getChildren("row")).isEmpty() || total == 0) {
            return BankReceiptResponseEB.success(detailList);
        }
        String currentPage = this.getCurrentPage();
        int currentPageInt = Integer.parseInt(currentPage);
        if (total <= currentPageInt * 100) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            this.setCurrentPage(String.valueOf(currentPageInt + 1));
        }
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String currency = row.getChildText("currencyType");
            detail.setCurrency(currency);
            String acctNo = row.getChildTextTrim("acctNo");
            String accountName = row.getChildTextTrim("accountName");
            String accountOpenNode = row.getChildTextTrim("accountOpenNode");
            String hostFlowNo = row.getChildTextTrim("hostFlowNo");
            detail.setOppAccNo(acctNo);
            detail.setOppAccName(accountName);
            detail.setOppBankName(accountOpenNode);
            String payAmount = row.getChildTextTrim("payAmount");
            String recAmount = row.getChildTextTrim("recAmount");
            String orderFlowNo = row.getChildTextTrim("orderFlowNo");
            detail.setDebitAmount(new BigDecimal(payAmount));
            detail.setCreditAmount(new BigDecimal(recAmount));
            detail.setReversed1(payAmount);
            detail.setReversed2(recAmount);
            detail.setReversed3(orderFlowNo);
            detail.setPayBankDetailSeqID(hostFlowNo);
            detailList.add(detail);
        }
        return BankReceiptResponseEB.success(detailList);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CBE010201";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public List<DetailInfo> queryReceiptList(String accNo, LocalDate transDate) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("1");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

