/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.glb.dc.service.receipt.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.glb.dc.service.util.GLBPacker;
import kd.ebg.receipt.banks.glb.dc.service.util.GLBStringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class ReceiptDownloadImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    private static final String FORMAT = "yyyyMMdd";

    public String pack(BankReceiptRequest request) {
        LocalDate transDate = request.getTransDate();
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"orderFlowNo", (String)request.getRequestStr());
        JDomUtils.addChild((Element)body, (String)"fileType", (String)"pdf");
        JDomUtils.addChild((Element)body, (String)"isDownload", (String)"true");
        JDomUtils.addChild((Element)body, (String)"accountNo", (String)request.getAccNo());
        JDomUtils.addChild((Element)body, (String)"transferDate", (String)transDate.format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        return BankReceiptResponseEB.success();
    }

    public String recv(InputStream inputStream) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String savePath = (String)runningParams.get("savePath");
        String fileName = (String)runningParams.get("fileName");
        try {
            byte[] getData = this.readInputStream(inputStream);
            String string = new String(getData);
            if (string.length() < 1000) {
                logger.info("\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)string);
            }
            if (EBGStringUtils.isEmpty((String)string)) {
                throw new ReceiptException(ResManager.loadKDString((String)"CBE070123\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"ReceiptDownloadImpl_0", (String)"ebg-receipt-banks-glb-dc", (Object[])new Object[0]));
            }
            File saveDir = FileCommonUtils.getFileByPath((String)savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            EBContext.getContext().setRemoveWriteResponseLog(false);
        }
        return "";
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CBE070123";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

