/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.glb.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.glb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.glb.dc.service.receipt.api.ReceiptDownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        DetailImpl bankReceiptInfoRequest = new DetailImpl();
        List<DetailInfo> details = bankReceiptInfoRequest.queryReceiptList(accNo, transDate);
        if (details.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-glb-dc", (Object[])new Object[0]));
        }
        for (DetailInfo detail : details) {
            String orderNo = detail.getPayBankDetailSeqID();
            String orderFlowNo = detail.getReversed3();
            String payAmount = detail.getReversed1();
            String recAmount = detail.getReversed2();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(orderFlowNo).build();
            String fileName = accNo + "_" + transDateStr + "_" + orderNo + "_" + payAmount + "_" + recAmount + ".pdf";
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            runningParams.put("fileName", fileName);
            runningParams.put("savePath", bakFilePath);
            EBContext.getContext().setRunningParams((Map)runningParams);
            ReceiptDownloadImpl download = new ReceiptDownloadImpl();
            download.doBiz(bankReceiptRequest);
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(fileName);
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-glb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

