/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.srb.cmp.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"SRB_CMP", (String)accNo, (String)transDateStr);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info(">>>>>>>>>\u4e0a\u9976\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        int count = 0;
        for (DownloadListDetail detail : downloadListDetails) {
            boolean succ = this.download(detail, bakFilePath, accNo, transDate, bankFtpProperties);
            if (!succ) continue;
            ++count;
        }
        logger.info("\u4e0a\u9976\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6570\u91cf{}", (Object)count);
        for (DownloadListDetail detail : downloadListDetails) {
            String filePath;
            String fileName = detail.getFileLink();
            logger.info("filename->{}", (Object)fileName);
            if (fileName.contains(".gz")) {
                logger.info("\u662fGZ\u538b\u7f29\u5305");
                filePath = bakFilePath + File.separator + fileName;
                String outFilePath = filePath.replace(".gz", "").replace(".pdf", "") + ".pdf";
                File file = FileCommonUtils.getFileByPath((String)filePath);
                if (!file.exists()) {
                    logger.info("{}-{}-{}-\u672c\u5730\u4e0d\u5b58\u5728\u8be5\u538b\u7f29\u5305", new Object[]{accNo, transDate, fileName});
                    continue;
                }
                boolean flag = GZFileUtils.unGzFile((String)filePath, (String)outFilePath);
                if (!flag) continue;
                logger.info("\u89e3\u538b\u6210\u529f\u4e86");
                logger.info("\u89e3\u538b\u5230\u7684\u6587\u4ef6\u5939{}", (Object)outFilePath);
                File receiptFile = FileCommonUtils.getFileByPath((String)outFilePath);
                logger.info("\u5f53\u524d\u6b63\u5728\u5904\u7406\u7684\u6587\u4ef6{}", (Object)receiptFile.getName());
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(detail.getFileName());
                result.add(downloadListDetail);
                boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)downloadListDetail.getFileName());
                if (!isMove) continue;
                try {
                    Files.delete(Paths.get(receiptFile.toURI()));
                }
                catch (IOException e) {
                    logger.info("\u6587\u4ef6\u5220\u9664\u5f02\u5e38{}", new Object[]{e.getMessage(), e});
                }
                continue;
            }
            if (!fileName.endsWith(".pdf")) continue;
            logger.info("\u662fpdf");
            filePath = bakFilePath + File.separator + fileName;
            File receiptFile = FileCommonUtils.getFileByPath((String)filePath);
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(detail.getFileName());
            boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)downloadListDetail.getFileName());
            if (!isMove) continue;
            logger.info("\u6539\u540d\u6210\u529f{}", (Object)downloadListDetail.getFileName());
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties) {
        String fileName = detail.getFileLink();
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp();
        }
        boolean flag = false;
        try {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftpPath = bankFtpProperties.getFtpPath();
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                flag = bankReceiptApiUtil.downloadReceiptFile(fileName, bakFilePath);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return flag;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

