/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.srb.cmp.service.detail;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.srb.cmp.service.detail.ProxyDownload;
import kd.ebg.receipt.banks.srb.cmp.service.utils.Common;
import kd.ebg.receipt.banks.srb.cmp.service.utils.Packer;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-receipt-banks-srb-cmp", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String tr_code = "200110";
        Element ap = Packer.createCommonHead(tr_code, "0");
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)acnt.getCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDecAndPrettyFormat((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        String[][] r2;
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(8);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s ,%2$s", (String)"DetailImpl_1", (String)"ebg-receipt-banks-srb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            log.error("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse(details);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = (String)new ProxyDownload().doBiz(BankReceiptRequest.builder().accNo(rqst.getAcnt().getAccNo()).transDate(rqst.getStartDate()).requestStr(file_name).build()).getData();
            }
            catch (Exception e) {
                log.error("[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"DetailImpl_2", (String)"ebg-receipt-banks-srb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u660e\u7ec6\u5185\u5bb9\uff1a" + content);
        for (String[] sub : r2 = this.parseRecord(content, recordNum, fieldNum)) {
            DetailInfo detailInfo = new DetailInfo();
            String host_serial_no = sub[2];
            String req_no = sub[3];
            String opp_acno = sub[8];
            String crdr_flag = sub[4];
            String amt = sub[5];
            detailInfo.setOppAccNo(opp_acno);
            detailInfo.setReversed1(amt);
            detailInfo.setReversed2(crdr_flag);
            detailInfo.setUniqueSeq(host_serial_no);
            detailInfo.setBizRefNo(req_no);
            details.add(detailInfo);
        }
        log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u5185\u5bb9\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    public String[][] parseRecord(String records, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)records, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            System.arraycopy(allrecord, (i + 1) * fieldNum, r2[i], 0, fieldNum);
        }
        return r2;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

