/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.srb.cmp.service.receipt;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.srb.cmp.service.utils.Common;
import kd.ebg.receipt.banks.srb.cmp.service.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class Receipt200218Impl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Receipt200218Impl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200218";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element ap = Packer.createCommonHead("200218", "0");
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String serialNo = paramsMap.getOrDefault("serial_no", "");
        String reqNo = paramsMap.getOrDefault("req_no", "");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"req_no", (String)reqNo);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDecAndPrettyFormat((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u56de\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s ,%2$s", (String)"Receipt200218Impl_0", (String)"ebg-receipt-banks-srb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String reportFileFlag = body.getChildTextTrim("ReportFileFlag");
        if ("0".equalsIgnoreCase(reportFileFlag)) {
            logger.info("\u65e0\u56de\u5355\u6587\u4ef6");
            return BankReceiptResponseEB.success();
        }
        String fileName = body.getChildTextTrim("ReportFileName");
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

