/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.drcb.cmp.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.drcb.cmp.service.receipt.api.ProxyDownload;
import kd.ebg.receipt.banks.drcb.cmp.service.util.Packer;
import kd.ebg.receipt.banks.drcb.cmp.service.util.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String FORMAT = "yyyyMMdd";
    private static final String CIRCLE_STR = "|";

    public String pack(BankReceiptRequest request) {
        LocalDate transDate = request.getTransDate();
        Element root = Packer.createHead("200110", request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)transDate.format(DateTimeFormatter.ofPattern(FORMAT)));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)transDate.format(DateTimeFormatter.ofPattern(FORMAT)));
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        List<Object> totalList = new ArrayList(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailImpl_1", (String)"ebg-receipt-banks-drcb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element head = root.getChild("head");
        Element body = root.getChild("body");
        if (null == body || null == body.getChildren() || body.getChildren().size() == 0) {
            return BankReceiptResponseEB.success(totalList);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        int record_num = Integer.parseInt(body.getChildTextTrim("record_num"));
        int field_num = Integer.parseInt(body.getChildTextTrim("field_num"));
        if (0 == record_num) {
            this.setLastPage(true);
            return BankReceiptResponseEB.success(totalList);
        }
        if ("0".equalsIgnoreCase(file_flag)) {
            String data = body.getChildTextTrim("serial_record");
            totalList = this.parserDetailData(data, record_num, field_num);
        } else if ("1".equalsIgnoreCase(file_flag)) {
            String fileName = body.getChildTextTrim("file_name");
            BankReceiptResponseEB responseEB = new ProxyDownload().doBiz(BankReceiptRequest.builder().accNo(request.getAcnt().getAccNo()).transDate(request.getTransDate()).requestStr(fileName).build());
            String data = (String)responseEB.getData();
            totalList = this.parserDetailData(data, record_num, field_num);
        }
        return BankReceiptResponseEB.success(totalList);
    }

    private List<DetailInfo> parserDetailData(String data, int record_num, int field_num) {
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        String[] fields = StringUtils.split((String)data, (String)CIRCLE_STR);
        for (int i = 1; i <= record_num; ++i) {
            String host_serial_no = fields[i * field_num];
            String acno = fields[i * field_num + 2];
            String opp_acno = fields[i * field_num + 8];
            String crdr_flag = fields[i * field_num + 23];
            String amt = fields[i * field_num + 24];
            String balance = fields[i * field_num + 25];
            String tr_acdt = fields[i * field_num + 4];
            String tr_time = fields[i * field_num + 5];
            String serial_no = fields[i * field_num + 1];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setOppAccNo(opp_acno);
            detail.setBalance(new BigDecimal(balance));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serial_no", (Object)serial_no);
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("tr_time", (Object)tr_time);
            jsonObject.put("acno", (Object)acno);
            jsonObject.put("opp_acno", (Object)opp_acno);
            jsonObject.put("amt", (Object)amt);
            jsonObject.put("crdr_flag", (Object)crdr_flag);
            jsonObject.put("balacne", (Object)balance);
            detail.setReversed1(jsonObject.toJSONString());
            totalList.add(detail);
        }
        return totalList;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public List<DetailInfo> queryReceiptList(String accNo, LocalDate transDate) {
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        BankHeader bankHeader = new BankHeader();
        bankHeader.setAcnt(acnt);
        request.setHeader(bankHeader);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        BankReceiptResponseEB response = this.doBiz(request);
        List receiveItems = (List)response.getData();
        if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
            detailInfos.addAll(receiveItems);
        }
        return detailInfos;
    }
}

