/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.itbjfcl.dc.receipt.service.fetch;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.itbjfcl.dc.receipt.service.api.DetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        return RequestContextUtils.receiptFormatIsFile() || FileCommonUtils.isTestEnv();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<DownloadListDetail> result = this.doJob_pushMode(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadListDetail> doJob_pushMode(DownloadListTask task) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String yyyyMMdd = task.getTransDate().toString();
        LocalDate transDate = task.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)accNo, (String)transDateStr);
        DetailImpl detailImpl = new DetailImpl();
        List<DetailInfo> detailInfoList = detailImpl.queryTransDetail(accNo, transDate, transDate);
        if (detailInfoList.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u8d26\u53f7\u5f53\u5929\u6ca1\u6709\u4ea4\u6613\u6d41\u6c34", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-itbjfcl-dc", (Object[])new Object[0]));
        }
        String bankLoginId = task.getBankLoginId();
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        ChannelSftp sftp = null;
        try {
            if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
            HashMap successMap = Maps.newHashMapWithExpectedSize((int)1);
            for (DownloadListDetail downloadListDetail : downloadListDetails) {
                if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                successMap.put(downloadListDetail.getFileLink(), downloadListDetail);
            }
            for (DetailInfo detailInfo : detailInfoList) {
                DownloadListDetail detail = new DownloadListDetail();
                String transNo = detailInfo.getReceiptNo();
                String cdFlag = detailInfo.getReversed1();
                String fileName = transNo + "-" + cdFlag + ".pdf";
                if (successMap.containsKey(fileName)) {
                    result.add((DownloadListDetail)successMap.get(fileName));
                    continue;
                }
                boolean isSuccess = this.downloadFileByName(task, fileName, bakFilePath, ftpProperties, sftp, yyyyMMdd);
                if (!isSuccess) continue;
                String newFileName = fileName.replace(".pdf", "") + "-" + detailInfo.getOppAccNo() + "-" + detailInfo.getReversed2() + ".pdf";
                File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                boolean isMove = FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newFileName);
                if (!isMove) continue;
                detail.setFileName(newFileName);
                detail.setFileLink(fileName);
                detail.setReceiptJson(detailInfo.getJson());
                result.add(detail);
            }
        }
        catch (Throwable throwable) {
            SFTPUtils.getInstance().close(sftp);
            throw throwable;
        }
        SFTPUtils.getInstance().close(sftp);
        return result;
    }

    public boolean downloadFileByName(DownloadListTask task, String fileName, String savePath, BankFtpProperties ftpProperties, ChannelSftp sftp, String yyyyMMdd) {
        try {
            if (ftpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftp_path = ftpProperties.getFtpPath();
                sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path + "/" + yyyyMMdd : "/" + yyyyMMdd;
                return SFTPUtils.getInstance().downloadSingleFile(sftp_path, fileName, savePath, sftp);
            }
            if (ftpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(task.getAccNo(), task.getTransDate());
                return bankReceiptApiUtil.downloadReceiptFileWithPath(ftpProperties.getFrontProxyPath() + File.separator + yyyyMMdd, fileName, savePath);
            }
        }
        catch (Throwable e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\uff1a{} \u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{fileName, e.getMessage(), e});
            return false;
        }
        return false;
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

