/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.simulator.service.receipt;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.receipt.banks.simulator.service.utils.QueryUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractReceiptImpl;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;

public class ReceiptImpl
extends AbstractReceiptImpl {
    public ReceiptResponseEB doBiz(ReceiptRequest request) {
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>(16);
        receiptInfoList.addAll(this.getPayReceiptList(request));
        receiptInfoList.addAll(this.getIncomeReceiptList(request));
        return this.initReceiptResponseEB(receiptInfoList);
    }

    private List<ReceiptInfo> getPayReceiptList(ReceiptRequest request) {
        String accNo = request.getAcnt().getAccNo();
        ArrayList<ReceiptInfo> payReceiptInfoList = new ArrayList<ReceiptInfo>(16);
        QFilter qFilter = QFilter.of((String)"status_id = ? and insert_time < ? and insert_time > ? and bank_version_id = ? and acc_no=?", (Object[])new Object[]{12, request.getEndDate().plusDays(1L).atTime(0, 0), request.getStartDate().atTime(0, 0), "EBG_SIM", accNo});
        List<DynamicObject> payList = QueryUtil.getInstance().queryPayments(qFilter);
        payReceiptInfoList.addAll(this.autowireBusinessObjectList(payList, true));
        return payReceiptInfoList;
    }

    private List<ReceiptInfo> getIncomeReceiptList(ReceiptRequest request) {
        String accNo = request.getAcnt().getAccNo();
        ArrayList<ReceiptInfo> incomeReceiptInfoList = new ArrayList<ReceiptInfo>(16);
        QFilter qFilter = QFilter.of((String)"status_id = ? and insert_time < ? and insert_time > ? and bank_version_id = ? and income_acc_no=?", (Object[])new Object[]{12, request.getEndDate().plusDays(1L).atTime(0, 0), request.getStartDate().atTime(0, 0), "EBG_SIM", accNo});
        List<DynamicObject> payList = QueryUtil.getInstance().queryPayments(qFilter);
        incomeReceiptInfoList.addAll(this.autowireBusinessObjectList(payList, false));
        return incomeReceiptInfoList;
    }

    private List<ReceiptInfo> autowireBusinessObjectList(List<DynamicObject> payList, boolean isDebit) {
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>(16);
        for (DynamicObject dynamicObject : payList) {
            ReceiptInfo receiptInfo = new ReceiptInfo();
            receiptInfo.setAccName(dynamicObject.getString("acc_name"));
            receiptInfo.setAccNo(dynamicObject.getString("acc_no"));
            receiptInfo.setAmount(dynamicObject.getString("actual_amount"));
            receiptInfo.setBankName(dynamicObject.getString("bank_name"));
            receiptInfo.setBusType("");
            BigDecimal actualAmount = dynamicObject.getBigDecimal("amount").setScale(2);
            receiptInfo.setDebitAmount(isDebit ? actualAmount.toPlainString() : null);
            receiptInfo.setCreditAmount(isDebit ? null : actualAmount.toPlainString());
            String isoCurrency = CurrencyUtils.convert2Iso((String)dynamicObject.getString("currency"));
            receiptInfo.setCurrency(isoCurrency);
            LocalDateTime transDateTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("submit_success_time"));
            receiptInfo.setTransDate(transDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            receiptInfo.setDetailDateTime(transDateTime.format(DateTimeFormatter.ofPattern("HHmmss")));
            receiptInfo.setExplanation(dynamicObject.getString("explanation"));
            receiptInfo.setEbillKey("");
            receiptInfo.setEbillSerialno("");
            receiptInfo.setFileFlag("0");
            receiptInfo.setFilePath("");
            receiptInfo.setJson("");
            receiptInfo.setMd5("");
            receiptInfo.setOppAccName(dynamicObject.getString("income_acc_name"));
            receiptInfo.setOppAccNo(dynamicObject.getString("income_acc_no"));
            receiptInfo.setOppBankName(dynamicObject.getString("income_bank_name"));
            receiptInfo.setRemark("");
            receiptInfo.setRePrintNum("0");
            receiptInfo.setReceiptNo(dynamicObject.getString("bank_detail_seq_id"));
            receiptInfo.setUseCn("");
            receiptInfo.setTranSerialNo("");
            receiptInfo.setTransNetCode("");
            receiptInfo.setTransTellno("");
            receiptInfo.setUploadFileName("");
            receiptInfo.setUploadFlag(0);
            receiptInfo.setValidateCode("");
            receiptInfoList.add(receiptInfo);
        }
        return receiptInfoList;
    }

    private ReceiptResponseEB initReceiptResponseEB(List<ReceiptInfo> receiptInfoList) {
        ArrayList<ReceiptInfo> copyReceiptInfoList = new ArrayList<ReceiptInfo>(16);
        copyReceiptInfoList.addAll(receiptInfoList);
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        responseEB.setFileFlag(0);
        responseEB.setCompleteFlag(1);
        responseEB.setHost("127.0.0.1");
        responseEB.setLastPage(true);
        responseEB.setPageNum(1);
        responseEB.setPageSize(copyReceiptInfoList.size());
        responseEB.setFileServerUrl("http://127.0.0.1/fileServer");
        responseEB.setPort(80);
        responseEB.setTotalCount((long)copyReceiptInfoList.size());
        responseEB.setReceiptInfos(copyReceiptInfoList);
        return responseEB;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(ReceiptRequest receiptRequest) {
        return null;
    }

    public ReceiptResponseEB parse(ReceiptRequest receiptRequest, String s) {
        return null;
    }
}

