/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jjccb.cmp.service.detail;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ProxyDownload
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final String BIZ_TYPE = "downloadFile";

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String fileName = bankReceiptRequest.getRequestStr();
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = ProxyDownload.createHead(BIZ_TYPE);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)"UTF-8");
        BankResponse response = ProxyDownload.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"ProxyDownload_0", (String)"ebg-receipt-banks-jjccb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"ProxyDownload_1", (String)"ebg-receipt-banks-jjccb-cmp", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if ("BIZ_SUCCESS".equalsIgnoreCase(ReturnCode) || "SUCCESS".equalsIgnoreCase(ReturnCode)) {
            String fileContent = JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
            return BankReceiptResponseEB.success((Object)fileContent);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 ,%1$s %2$s", (String)"ProxyDownload_2", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]), ReturnCode, ReturnMsg));
    }

    public void configFactory(ConnectionFactory factory) {
        String frontPort = RequestContextUtils.getBankParameterValue((String)"frontProxy_Port");
        factory.setPort(frontPort);
        factory.setProtocol("HTTP");
    }

    public static Element createHead(String bizType) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)Sequence.genSequence());
        return head;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getUnNullChildElement((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getUnNullChildTextTrim((Element)Head, (String)"rspcode");
        String IBSReturnMsg = JDomUtils.getUnNullChildTextTrim((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

