/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmbc.dc.service.receipt.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cmbc.dc.service.CMBCDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptFileDownImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFileDownImpl.class);

    public String pack(BankReceiptRequest request) {
        Map paramsMap = request.getParamsMap();
        String insId = Sequence.genSequence();
        String innerNo = (String)paramsMap.get("innerNo");
        String xmlFileName = (String)paramsMap.get("xmlFileName");
        String requestStr = this.getDownLoadRequest(insId, innerNo, xmlFileName);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return requestStr;
    }

    private String getDownLoadRequest(String insId, String innerNo, String xmlFileName) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        String request = "";
        Element root = JDomExtUtils.createRoot((String)"CMBC");
        root.setAttribute("header", "100");
        root.setAttribute("version", "100");
        root.setAttribute("security", "none");
        root.setAttribute("lang", "chs");
        root.setAttribute("trnCode", "b2eElectNoteDownLoad");
        String bankLogin = EBContext.getContext().getBankLoginID();
        CMBCDCCommConfig config = (CMBCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CMBCDCCommConfig.class, bankLogin);
        String clientId = config.getReceipFitchList_clientId();
        String userId = config.getReceipFitchList_userId();
        String userPswd = config.getReceipFitchList_psd();
        Element header = JDomUtils.addChild((Element)root, (String)"requestHeader");
        String dtClient = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyy-MM-dd hh:mm:ss"));
        JDomUtils.addChild((Element)header, (String)"dtClient", (String)dtClient);
        JDomUtils.addChild((Element)header, (String)"clientId", (String)clientId);
        JDomUtils.addChild((Element)header, (String)"userId", (String)userId);
        JDomUtils.addChild((Element)header, (String)"userPswd", (String)userPswd);
        String language = "chs";
        JDomUtils.addChild((Element)header, (String)"language", (String)language);
        String appId = "nsbdes";
        JDomUtils.addChild((Element)header, (String)"appId", (String)appId);
        String appVer = "203";
        JDomUtils.addChild((Element)header, (String)"appVer", (String)appVer);
        Element body = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)body, (String)"insId", (String)insId);
        JDomUtils.addChild((Element)body, (String)"innerNo", (String)innerNo);
        JDomUtils.addChild((Element)body, (String)"xmlFileName", (String)xmlFileName);
        request = JDomExtUtils.doc2StrGBK((Document)new Document(root));
        return request;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        logger.info("CMBC_DC-\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d-\u54cd\u5e94\u62a5\u6587\uff1a\n" + (responseStr.length() > 1000 ? responseStr.substring(0, 1000) : responseStr));
        return BankReceiptResponseEB.success((Object)responseStr);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMBC_DC_BANK_RECEIPT_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6c11\u751f\u94f6\u884c\u63a8\u5e7f\u7248\u94f6\u884c\u56de\u5355\u67e5\u8be2\u8bf7\u6c42", (String)"BankReceiptFileDownImpl_0", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/eweb/b2e/connect.do");
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

