/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmbc.dc.service.receipt.api;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cmbc.dc.service.CMBCDCCommConfig;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.info.CmbcFileInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String beginDate = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Map paramsMap = request.getParamsMap();
        int pageNo = (Integer)paramsMap.get("pageNo");
        String requestStr = this.packRequestXml(accNo, beginDate, pageNo);
        return requestStr;
    }

    private String packRequestXml(String saAcctNo, String BeginDate, Integer pageNo) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        CMBCDCCommConfig config = (CMBCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CMBCDCCommConfig.class, bankLogin);
        String clientId = config.getReceipFitchList_clientId();
        String userId = config.getReceipFitchList_userId();
        String userPswd = config.getReceipFitchList_psd();
        String insId = Sequence.genSequence();
        String printState = "";
        String pageSize = "10";
        printState = config.getPrint_state().equals("ALL") ? "0" : (config.getPrint_state().equals("PRINT") ? "1" : "2");
        Element root = JDomExtUtils.createRoot((String)"CMBC");
        root.setAttribute("header", "100");
        root.setAttribute("version", "100");
        root.setAttribute("security", "none");
        root.setAttribute("lang", "chs");
        root.setAttribute("trnCode", "b2eElectNoteQryNew");
        Element header = JDomUtils.addChild((Element)root, (String)"requestHeader");
        String dtClient = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyy-MM-dd hh:mm:ss"));
        JDomUtils.addChild((Element)header, (String)"dtClient", (String)dtClient);
        JDomUtils.addChild((Element)header, (String)"clientId", (String)clientId);
        JDomUtils.addChild((Element)header, (String)"userId", (String)userId);
        JDomUtils.addChild((Element)header, (String)"userPswd", (String)userPswd);
        String language = "chs";
        JDomUtils.addChild((Element)header, (String)"language", (String)language);
        String appId = "nsbdes";
        JDomUtils.addChild((Element)header, (String)"appId", (String)appId);
        String appVer = "203";
        JDomUtils.addChild((Element)header, (String)"appVer", (String)appVer);
        Element body = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)body, (String)"insId", (String)insId);
        JDomUtils.addChild((Element)body, (String)"saAcctNo", (String)saAcctNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)BeginDate);
        String EndDate = BeginDate;
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)EndDate);
        JDomUtils.addChild((Element)body, (String)"PrintState", (String)printState);
        JDomUtils.addChild((Element)body, (String)"pageNo", (String)(pageNo + ""));
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)pageSize);
        Document doc = new Document(root);
        String content = JDomExtUtils.doc2StrGB2312((Document)doc);
        return content;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Map<String, CmbcFileInfo> fileInfoMap = this.parseResponse(responseStr);
        return BankReceiptResponseEB.success(fileInfoMap);
    }

    public Map<String, CmbcFileInfo> parseResponse(String response) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element status = root.getChild("responseHeader").getChild("status");
        String code = JDomUtils.getUnNullChildElement((Element)status, (String)"code").getTextTrim();
        String msg = JDomUtils.getUnNullChildElement((Element)status, (String)"message").getTextTrim();
        if ("0".equalsIgnoreCase(code)) {
            Element xDataBody = JDomExtUtils.getChildElement((Element)root, (String)"xDataBody");
            Element list = JDomExtUtils.getChildElement((Element)xDataBody, (String)"List");
            List maps = list.getChildren("Map");
            for (Element map : maps) {
                String innerNo = JDomExtUtils.getChildText((Element)map, (String)"innerNo");
                String trsDate = JDomExtUtils.getChildText((Element)map, (String)"TrsDate");
                String acNo = JDomExtUtils.getChildText((Element)map, (String)"AcNo");
                String fileLink = JDomExtUtils.getChildText((Element)map, (String)"FileName");
                String svrId = JDomExtUtils.getChildText((Element)map, (String)"svrId");
                if (svrId == null) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u8c03\u7528b2eElectNoteQry\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u9519\u8bef\u62a5\u6587\uff0c\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728\u3002", (String)"BankReceiptQueryImpl_0", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]));
                }
                String loanFlag = JDomExtUtils.getChildText((Element)map, (String)"LoanFlag");
                String trsAmount = JDomExtUtils.getChildText((Element)map, (String)"TrsAmount");
                if (EBGStringUtils.isEmpty((String)innerNo)) continue;
                CmbcFileInfo info = new CmbcFileInfo();
                StringBuilder builder = new StringBuilder();
                builder.append(trsDate).append("+").append(acNo).append("+").append(loanFlag).append("+").append(trsAmount).append("+").append(svrId).append("+").append(innerNo).append(".pdf");
                info.setFileName(builder.toString());
                info.setFileLink(innerNo + "+" + fileLink);
                result.put(innerNo, info);
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528b2eElectNoteQry\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptQueryImpl_3", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]), code, msg));
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMBC_DC_BANK_RECEIPT_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6c11\u751f\u94f6\u884c\u63a8\u5e7f\u7248\u94f6\u884c\u56de\u5355\u67e5\u8be2\u8bf7\u6c42", (String)"BankReceiptQueryImpl_2", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/eweb/b2e/connect.do");
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

