/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.arcu.dc.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.arcu.dc.service.api.DetailImpl;
import kd.ebg.receipt.banks.arcu.dc.service.api.DownLoadBankReceiptImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private static final String RECEIPTSEPERATOR = "_";

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        ArrayList result = new ArrayList(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        BankDetailRequest req = this.buildReq(accNo, transDate);
        DetailImpl dImp = new DetailImpl();
        EBBankDetailResponse dResp = dImp.doBiz(req);
        dResp.getDetails().forEach(e -> {
            String uniqueSeq = e.getUniqueSeq();
            String bal = e.getBalance().toString();
            String oppAccNo = e.getOppAccNo();
            String fileName = accNo + RECEIPTSEPERATOR + transDate + RECEIPTSEPERATOR + uniqueSeq + RECEIPTSEPERATOR + oppAccNo + RECEIPTSEPERATOR + bal + ".pdf";
            RequestContextUtils.setRunningParam((String)"fileName", (String)fileName);
            RequestContextUtils.setRunningParam((String)"AccNo", (String)accNo);
            RequestContextUtils.setRunningParam((String)"TransDate", (String)transDateStr);
            RequestContextUtils.setRunningParam((String)"HostJnlNo", (String)uniqueSeq);
            RequestContextUtils.setRunningParam((String)"Amount", (String)bal);
            RequestContextUtils.setRunningParam((String)"PayeeAcNo", (String)oppAccNo);
            DownLoadBankReceiptImpl downLoad = new DownLoadBankReceiptImpl();
            downLoad.doBiz(new BankReceiptRequest());
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileName(fileName);
            detail.setFileLink(fileName);
            result.add(detail);
        });
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankDetailRequest buildReq(String accNo, LocalDate localDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(localDate);
        request.setEndDate(localDate);
        return request;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BOSH_BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }
}

