/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.mservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBRequestEnhance;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.security.util.EBFrontUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.balanceReconciliation.BalanceReconciliationRequestBody;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationRequestBody;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.log.MDCUtil;
import kd.ebg.receipt.common.front.api.biz.EBResponseCode;
import kd.ebg.receipt.common.front.api.boot.utils.FrontCheckUtil;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.common.utils.reconciliation.BalanceReconciliationUtils;
import kd.ebg.receipt.mservice.facade.config.FacadeProperties;
import kd.ebg.receipt.mservice.facade.utils.CommonUtils;
import kd.ebg.receipt.mservice.facade.utils.LogUtil;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBGateway
implements IBillWebApiPlugin {
    private static EBGateway instance = new EBGateway();
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBGateway.class);
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static Map<String, Map<String, Class>> customizeMethodCache = Maps.newHashMapWithExpectedSize((int)16);
    private static final long maxWaitTime = 30L;
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)1000.0);
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private FacadeProperties properties;

    public static EBGateway getInstance() {
        return instance;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        return ApiResult.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResult doCustomService(Map<String, Object> params) {
        MDCUtil.clearBussinessMDC();
        ApiResult result = new ApiResult();
        EBServiceResponse response = null;
        String responseData = "";
        String jsonMap = JSONObject.fromObject(params).toString();
        logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u65e5\u5fd7\uff1a{}", (Object)jsonMap);
        EBServiceRequest request = (EBServiceRequest)JsonUtil.json2Obj((String)jsonMap, EBServiceRequest.class);
        logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u63a5\u53e3-invoke");
        this.properties = (FacadeProperties)SpringContextUtil.getBean(FacadeProperties.class);
        try {
            EBException ebException;
            String customID = RequestContext.get().getTenantId();
            logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u63a5\u53e3-customID:{}", (Object)customID);
            if (EBGStringUtils.isEmpty((String)customID)) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBGateway_0", (String)"ebg-receipt-mservice", (Object[])new Object[0]), customID));
            }
            if ("api".equalsIgnoreCase(RequestContext.get().getClient()) && !EBGStringUtils.equalsIgnoreCase((String)customID, (String)request.getCustomerID())) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u79df\u6237\u53f7\u4e0e\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5339\u914d\u3002", (String)"EBGateway_1", (String)"ebg-receipt-mservice", (Object[])new Object[0]), customID));
            }
            request.setCustomerID(customID);
            boolean tryAcquire = globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
            if (!tryAcquire) {
                rateLimiterRejectCount.incrementAndGet();
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5168\u5c40\u9650\u6d41", (String)"EBGateway_2", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
            }
            RateLimiter rateLimiter = customRateLimiter.get(request.getCustomerID());
            if (Objects.isNull(rateLimiter)) {
                rateLimiter = this.createForCustom(request.getCustomerID());
            }
            if (!rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) {
                logger.warn("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", new Object[]{request.getCustomerID()});
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5355\u79df\u6237\u9650\u6d41", (String)"EBGateway_3", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
            }
            FrontCheckUtil.checkRequest((EBBaseRequest)request);
            if (this.properties.isTimeLimitCheck() && !FrontCheckUtil.checkTimeLimited((EBBaseRequest)request, (long)this.properties.getTimeLimit(), (long)this.properties.getTimeTolerate())) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u6548:\u8bf7\u6c42\u65f6\u95f4\u6233\u4e0d\u80fd\u8d85\u8fc7\u94f6\u4f01\u670d\u52a1\u5668\u65f6\u95f4\u6216\u8bf7\u6c42\u95f4\u9694\u592a\u4e45\uff0c%sms\u3002", (String)"EBGateway_10", (String)"ebg-receipt-mservice", (Object[])new Object[0]), Math.abs(System.currentTimeMillis() - request.getTimestamp())));
            }
            boolean isCheckSign = Boolean.parseBoolean(System.getProperty("ignoreCheckSign"));
            logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u63a5\u53e3-isCheckSign:{}", (Object)isCheckSign);
            if ("register".equalsIgnoreCase(request.getBizType())) {
                isCheckSign = true;
            }
            if (!isCheckSign) {
                LogUtil.infoRequest((EBBaseRequest)request);
                boolean isValid = EBFrontUtil.decryptAndVerifyEBSecurityRequest((EBServiceRequest)request);
                logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u63a5\u53e3-\u9a8c\u7b7e\u7ed3\u679c:{}", (Object)isValid);
                if (!isValid) {
                    throw new EBSecurityException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7b7e\u540d\u672a\u901a\u8fc7\u3002", (String)"EBGateway_5", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                }
            }
            EBRequestEnhance ebRequestEnhance = (EBRequestEnhance)JsonUtil.json2Obj((String)request.getData(), EBRequestEnhance.class);
            LogUtil.debugRequest((EBBaseRequest)request);
            String data = request.getData();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)data), (Object)ResManager.loadKDString((String)"data \u4e3a\u7a7a\u3002", (String)"EBGateway_6", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
            String bizType = request.getBizType();
            String customId = request.getCustomerID();
            String requestSeqID = "";
            String bizSeqID = Sequence.gen18Sequence();
            String batchSeqId = ebRequestEnhance.getBody().getBatchSeqId();
            if (!EBGStringUtils.isEmpty((String)batchSeqId)) {
                bizSeqID = batchSeqId;
            }
            if ("ping".equalsIgnoreCase(ebRequestEnhance.getHeader().getBizType())) {
                MDC.put((String)BANK_VERSION_ID, (String)ebRequestEnhance.getHeader().getExtData());
            }
            requestSeqID = String.valueOf(ebRequestEnhance.getHeader().getRequestTime());
            ebRequestEnhance.setLogRequestSeqId(requestSeqID);
            ebRequestEnhance.setCustomId(customId);
            ebRequestEnhance.setLogBizSeqId(bizSeqID);
            String logger_bank_no = Sequence.gen18Sequence();
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(requestSeqID).bizName(bizType).subBizName(bizType).bankVersionID("").logBizSeqID(bizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(logger_bank_no).build();
            EBContext.setContext((EBContext)context);
            JSONObject object = new JSONObject();
            object.put((Object)"loggerBatchNo", (Object)bizSeqID);
            object.put((Object)"loggerDetailNo", (Object)bizSeqID);
            object.put((Object)"loggerBankNo", (Object)logger_bank_no);
            ebRequestEnhance.getHeader().setExtData(object.toString());
            if (Objects.equals(bizType, "receiptPage") || Objects.equals(bizType, "receipt")) {
                context.setBizName("queryReceipt");
            }
            if (Objects.equals(bizType, "balanceReconciliationQuery") || Objects.equals(bizType, "balanceReconciliationQueryPage")) {
                context.setBizName("balanceReconciliationQuery");
            }
            if (Objects.equals(bizType, "balanceReconciliate")) {
                context.setBizName("balanceReconciliation");
            }
            MDCUtil.initMDC();
            logger.infoRequest("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson(data));
            EBResponse ebResponse = null;
            try {
                switch (bizType) {
                    case "receiptPage": 
                    case "receipt": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"receipt", (String)"receipt", (Object[])new Object[]{EBGateway.getRequest(QueryReceiptRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "receiptDownload": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"receipt", (String)"receiptDownload", (Object[])new Object[]{EBGateway.getRequest(QueryReceiptRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "reconciliation": 
                    case "reconciliationPage": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"receipt", (String)"reconciliation", (Object[])new Object[]{EBGateway.getRequest(QueryReceiptRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "balanceReconciliationQuery": 
                    case "balanceReconciliationQueryPage": {
                        context.setBizName("balanceReconciliationQuery");
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"receipt", (String)"balanceReconciliationQuery", (Object[])new Object[]{EBGateway.getRequest(QueryBalanceReconciliationRequest.class, data, ebRequestEnhance)});
                        EBHeader ebHeader = ebResponse.getHeader();
                        if (ebHeader != null) {
                            ebHeader.setAccNo("");
                        }
                        break;
                    }
                    case "balanceReconciliate": {
                        context.setBizName("balanceReconciliation");
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"receipt", (String)"balanceReconciliate", (Object[])new Object[]{EBGateway.getRequest(BalanceReconciliationRequest.class, data, ebRequestEnhance)});
                        EBHeader ebHeader1 = ebResponse.getHeader();
                        if (ebHeader1 != null) {
                            ebHeader1.setAccNo("");
                        }
                        break;
                    }
                    default: {
                        boolean flag = false;
                        for (Map.Entry<String, Map<String, Class>> entry : customizeMethodCache.entrySet()) {
                            String key = entry.getKey();
                            if (!bizType.equals(key)) continue;
                            flag = true;
                            ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"receipt", (String)"customize", (String)"customize", (Object[])new Object[]{EBGateway.getRequest(customizeMethodCache.get(key).get("requestClass"), data, ebRequestEnhance)});
                            break;
                        }
                        if (!flag) {
                            throw new EBBaseException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u672a\u77e5\u3002", (String)"EBGateway_7", (String)"ebg-receipt-mservice", (Object[])new Object[0]));
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                logger.error("\u4e1a\u52a1\u5904\u7406\u5f02\u5e38\uff1a", e);
                response = new EBServiceResponse();
                response.setVersion(request.getVersion());
                response.setResponseCode(EBResponseCode.BIZ_ERROR.getResponseCode());
                response.setResponseMsg(EBResponseCode.BIZ_ERROR.getResponseMessage());
                if (ebResponse == null) {
                    ebResponse = new EBResponse();
                }
                EBException ebException2 = new EBException();
                ebException2.setMessage(e.getMessage());
                ebException2.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
                ebResponse.setException(ebException2);
                responseData = JsonUtil.toJsonLine((Object)ebResponse);
                this.setContextResponse();
                logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
                response.setData(responseData);
                EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
            }
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            String responseCode = null;
            String responseMsg = null;
            if (ebResponse != null && Objects.isNull(ebResponse.getException())) {
                responseCode = EBResponseCode.BIZ_SUCCESS.getResponseCode();
                responseMsg = EBResponseCode.BIZ_SUCCESS.getResponseMessage();
            } else if (ebResponse != null && (ebException = ebResponse.getException()) != null) {
                if (ebException.getInnerException() != null) {
                    if (ebException.getInnerException().equals("preException")) {
                        responseCode = EBResponseCode.BASE_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BASE_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    } else if (ebException.getInnerException().equals("serviceException")) {
                        responseCode = EBResponseCode.BIZ_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BIZ_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    }
                } else {
                    responseCode = EBResponseCode.DUBBO_ERROR.getResponseCode();
                    responseMsg = EBResponseCode.DUBBO_ERROR.getResponseMessage();
                }
            }
            response.setResponseCode(responseCode);
            response.setResponseMsg(responseMsg);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u8fd4\u56de\u5f02\u5e38\uff1a", (Throwable)e);
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            response.setResponseCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            response.setResponseMsg(EBResponseCode.SECURITY_ERROR.getResponseMessage());
            EBResponse ebResponse = new EBResponse();
            EBException ebException = new EBException();
            ebException.setErrorCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            ebException.setMessage(e.getMessage());
            ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
            ebResponse.setException(ebException);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        finally {
            EBContext.destroy();
        }
        boolean isIgnoreSign = Boolean.parseBoolean(System.getProperty("ignoreSign"));
        if (!isIgnoreSign) {
            EBFrontUtil.signResponse((EBServiceResponse)response, (EBBaseRequest)request);
        }
        if (response.getResponseCode().equals(EBResponseCode.BIZ_SUCCESS.getResponseCode())) {
            result.setErrorCode("success");
            result.setData((Object)response);
            result.setSuccess(true);
        } else {
            result.setErrorCode("fail");
            result.setData((Object)response);
            result.setSuccess(false);
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        return result;
    }

    private void setContextResponse() {
        try {
            EBContext.getContext().setType("response");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static <T extends EBRequest> T getRequest(Class<T> requestClass, String data, EBRequestEnhance ebRequestEnhance) {
        EBRequest request = (EBRequest)JsonUtil.json2Obj((String)data, requestClass);
        request.getHeader().setCustomId(ebRequestEnhance.getCustomId());
        request.getHeader().setLogBizSeqID(ebRequestEnhance.getLogBizSeqId());
        request.getHeader().setLogRequestSeqID(ebRequestEnhance.getLogRequestSeqId());
        request.getHeader().setExtData(ebRequestEnhance.getHeader().getExtData());
        EBGateway.handBalanceReconciliationRequest(requestClass, request);
        return (T)request;
    }

    public static <T extends EBRequest> void handBalanceReconciliationRequest(Class<T> requestClass, T request) {
        EBHeader ebHeader = request.getHeader();
        if (request == null) {
            return;
        }
        if (requestClass == QueryBalanceReconciliationRequest.class) {
            QueryBalanceReconciliationRequest balanceReconciliationRequest = (QueryBalanceReconciliationRequest)request;
            QueryBalanceReconciliationRequestBody body = balanceReconciliationRequest.getBody();
            if (body != null) {
                String accNo = body.getAccNo();
                String bankCode = body.getBankCode();
                accNo = BalanceReconciliationUtils.getAccNoByBankCodeAndNull((String)bankCode, (String)accNo);
                ebHeader.setAccNo(accNo);
                balanceReconciliationRequest.setHeader(ebHeader);
            }
            return;
        }
        if (requestClass == BalanceReconciliationRequest.class) {
            BalanceReconciliationRequest balanceReconciliationRequest = (BalanceReconciliationRequest)request;
            BalanceReconciliationRequestBody body = balanceReconciliationRequest.getBody();
            if (body != null) {
                String accNo = body.getAccNo();
                String bankCode = body.getBankCode();
                accNo = BalanceReconciliationUtils.getAccNoByBalanceReconciliationAndNull((String)bankCode, (String)accNo, (String)body.getReconciliationNo());
                ebHeader.setAccNo(accNo);
                balanceReconciliationRequest.setHeader(ebHeader);
            }
            return;
        }
    }
}

