/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gxnx.dc.service.receipt.api.HisDetailImpl;
import kd.ebg.receipt.banks.gxnx.dc.service.receipt.api.OneReceiptCreateImpl;
import kd.ebg.receipt.banks.gxnx.dc.service.receipt.utils.GzipUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        HisDetailImpl detailImpl = new HisDetailImpl();
        List queryTransDetail = detailImpl.queryTransDetail(accNo, transDate, transDate);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).build();
        if (queryTransDetail.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]));
        }
        OneReceiptCreateImpl oneReceiptCreate = new OneReceiptCreateImpl();
        String tempPath = FileStorageUtil.getFileBatchBakPathByTransDate((String)request.getBankVersionId(), (String)transDateStr);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DetailInfo detailInfo : queryTransDetail) {
            String hostFlowNo = detailInfo.getReversed1();
            String amount = detailInfo.getReversed3();
            String cdFlag = detailInfo.getReversed2();
            String oppAccNo = detailInfo.getOppAccNo();
            String json = detailInfo.getJson();
            if (EBGStringUtils.isEmpty((String)oppAccNo)) {
                oppAccNo = "e";
            }
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(hostFlowNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo).append("_");
            fileName.append(cdFlag).append("_");
            bankReceiptRequest.setRequestStr(hostFlowNo);
            String filePre = fileName.toString();
            if (countMap.containsKey(filePre)) {
                int serial = (Integer)countMap.get(filePre) + 1;
                countMap.put(filePre, serial);
                fileName.append("_").append(String.format("%04d", serial));
            } else {
                countMap.put(filePre, 0);
            }
            fileName.append(".pdf");
            String receiptName = fileName.toString();
            BankReceiptResponseEB receiptResponseEB = oneReceiptCreate.doBiz(bankReceiptRequest);
            Map map = (Map)receiptResponseEB.getData();
            try {
                if (!GzipUtil.handReceiptFileContent(tempPath, map, bakFilePath, receiptName)) continue;
                downloadListDetail.setFileLink(receiptName);
                downloadListDetail.setFileName(receiptName);
                downloadListDetail.setReceiptJson(json);
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.error("\u94f6\u884c\u63a5\u53e3\u8fd4\u56de\u7684\u6587\u4ef6\u6d41\u5185\u5bb9" + (String)map.get("FileCont"), e);
            }
            finally {
                FileCommonUtils.deleteFile((String)tempPath);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

