/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.dc.service.receipt.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gxnx.dc.service.receipt.utils.Tcommon;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import org.jdom2.Element;

public class GxnxPacker {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(GxnxPacker.class);

    private static Element packReqHead(String transCode, String seqId) {
        Element head = new Element("REQHEAD");
        JDomUtils.addChild((Element)head, (String)"TranCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"UserID"));
        JDomUtils.addChild((Element)head, (String)"ErpNo", (String)RequestContextUtils.getBankParameterValue((String)"ErpNo"));
        if (StringUtils.isEmpty((String)seqId)) {
            JDomUtils.addChild((Element)head, (String)"TranSeq", (String)GxnxPacker.getTranSeq(transCode));
        } else {
            JDomUtils.addChild((Element)head, (String)"TranSeq", (String)seqId);
        }
        JDomUtils.addChild((Element)head, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)head, (String)"TranTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"ChannelID", (String)"B2");
        return head;
    }

    private static String getTranSeq(String transCode) {
        String dateStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String ErpNo = RequestContextUtils.getBankParameterValue((String)"ErpNo");
        String tranCode = transCode.substring(0, 4);
        StringBuilder sb = new StringBuilder();
        sb.append(dateStr).append(ErpNo).append(tranCode).append(Sequence.gen8Sequence());
        return sb.toString();
    }

    private static Element packRoot() {
        return JDomUtils.createRoot((String)"GXNXYQ");
    }

    public static String packHisDetail(BankDetailRequest request, String pageTag) {
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("1004S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        String accNo = request.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"QryNo", (String)"10");
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }

    public static String packOneReceiptCreate(String accNo, String transDateStr, String orderNo) {
        Element root = GxnxPacker.packRoot();
        Element req = JDomUtils.addChild((Element)root, (String)"REQ");
        Element reqHead = GxnxPacker.packReqHead("5001S", "");
        JDomUtils.addChild((Element)req, (Element)reqHead);
        Element body = JDomUtils.addChild((Element)req, (String)"REQBODY");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"TranDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"SerSeqNo", (String)orderNo);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return Tcommon.createCommonMsg(RspMsg);
    }
}

