/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.dc.service.receipt.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class GxnxParser {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(GxnxParser.class);

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr) {
        if (StringUtils.isEmpty((String)rspStr)) {
            logger.info("\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"GxnxParser_4", (String)"ebg-receipt-banks-gxnx-dc", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String rspCode = head.getChildText("RspCode");
        String rspMsg = head.getChildText("RspMsg");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        JDomUtils.getChildText((Element)head, (String)"TranCode");
        JDomUtils.getChildText((Element)head, (String)"UserID");
        JDomUtils.getChildText((Element)head, (String)"TranSeq");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            logger.info("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:" + rspCode + ", " + rspMsg);
            return detailInfos;
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        Element MAININF = JDomUtils.getChildElement((Element)body, (String)"MAININF");
        JDomUtils.getChildText((Element)MAININF, (String)"SumNo");
        JDomUtils.getChildText((Element)MAININF, (String)"RetNo");
        Element listElement = body.getChild("LIST");
        List list = listElement.getChildren("PARAM");
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String RecAcctNo = row.getChildText("RecAcctNo");
            String RecAcctName = row.getChildText("RecAcctName");
            String amount = row.getChildText("TranAmt");
            String dcFlag = row.getChildText("CDFlag");
            String serSeqNo = row.getChildText("SerSeqNo");
            detail.setOppAccNo(RecAcctNo);
            detail.setOppAccName(RecAcctName);
            detail.setReversed1(serSeqNo);
            detail.setReversed2(dcFlag);
            detail.setReversed3(amount);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJson(jsonStr);
            detailInfos.add(detail);
        }
        return detailInfos;
    }

    public static Map<String, String> parseReceiptResponse(String rspStr) {
        if (StringUtils.isEmpty((String)rspStr)) {
            logger.info("\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"GxnxParser_5", (String)"ebg-receipt-banks-gxnx-dc", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element resp = JDomUtils.getChildElement((Element)root, (String)"RESP");
        Element head = JDomUtils.getChildElement((Element)resp, (String)"RESPHEAD");
        String rspCode = head.getChildText("RspCode");
        String rspMsg = head.getChildText("RspMsg");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            logger.info("\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:" + rspCode + ", " + rspMsg);
            String errorMag = rspCode + ", " + rspMsg;
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\uff0c\u94f6\u884c\u8fd4\u56de:%s\u3002", (String)"GxnxParser_6", (String)"ebg-receipt-banks-gxnx-dc", (Object[])new Object[0]), errorMag));
        }
        Element body = JDomUtils.getChildElement((Element)resp, (String)"RESPBODY");
        String FileName = body.getChildText("FileName");
        String FileList = body.getChildText("FileList");
        String FileCont = body.getChildText("FileCont");
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("FileName", FileName);
        map.put("FileList", FileList);
        map.put("FileCont", FileCont);
        return map;
    }
}

