/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qlb.dc.service;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.receipt.banks.qlb.dc.service.api.FetchHisBankReceiptListImpl;
import kd.ebg.receipt.banks.qlb.dc.service.api.FetchTodayBankReceiptListImpl;
import kd.ebg.receipt.banks.qlb.dc.service.api.HisBankReceiptImpl;
import kd.ebg.receipt.banks.qlb.dc.service.api.TodayBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)date);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        String url = "";
        try {
            if (transDate.isEqual(LocalDate.now())) {
                logger.info("\u5f53\u65e5\u56de\u5355");
                BankReceiptRequest req = this.buildReq(accNo, transDate);
                FetchTodayBankReceiptListImpl impl = new FetchTodayBankReceiptListImpl();
                List<Map<String, Object>> dataBag = impl.process(req);
                for (Map<String, Object> data : dataBag) {
                    String no = (String)data.get("transferFlowNo");
                    String amount = (String)data.get("transferSum");
                    String fileName = accNo + "_" + date + "_" + no + "_" + amount + ".pdf";
                    TodayBankReceiptImpl todayBankReceipt = new TodayBankReceiptImpl();
                    req.setParamsMap(data);
                    BankReceiptResponseEB resp = todayBankReceipt.doBiz(req);
                    if (Objects.isNull(resp.getData())) continue;
                    String ds = (String)resp.getData();
                    byte[] urlByte = Base64.getDecoder().decode(ds);
                    url = new String(urlByte, "GBK");
                    URL downloadUrl = new URL(url);
                    String protocol = downloadUrl.getProtocol();
                    logger.info("\u534f\u8bae:{}", (Object)protocol);
                    if ("https".equalsIgnoreCase(protocol)) {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTPS");
                    } else {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTP");
                    }
                    DownloadUtils.download((String)url, (String)fileName, (String)bakFilePath);
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(fileName);
                    downloadListDetail.setFileLink(fileName);
                    result.add(downloadListDetail);
                }
            } else {
                logger.info("\u5386\u53f2\u56de\u5355");
                BankReceiptRequest req = this.buildReq(accNo, transDate);
                FetchHisBankReceiptListImpl impl = new FetchHisBankReceiptListImpl();
                List<Map<String, Object>> dataBag = impl.process(req);
                for (Map<String, Object> data : dataBag) {
                    String no = (String)data.get("transferFlowNo");
                    String amount = (String)data.get("amount");
                    String fileName = accNo + "_" + date + "_" + no + "_" + amount + ".pdf";
                    HisBankReceiptImpl hisBankReceipt = new HisBankReceiptImpl();
                    req = this.buildReq(accNo, transDate);
                    req.setParamsMap(data);
                    BankReceiptResponseEB resp = hisBankReceipt.doBiz(req);
                    if (Objects.isNull(resp.getData())) continue;
                    String ds = (String)resp.getData();
                    byte[] urlByte = Base64.getDecoder().decode(ds);
                    url = new String(urlByte, "GBK");
                    URL downloadUrl = new URL(url);
                    String protocol = downloadUrl.getProtocol();
                    logger.info("\u534f\u8bae:{}", (Object)protocol);
                    if ("https".equalsIgnoreCase(protocol)) {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTPS");
                    } else {
                        RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTP");
                    }
                    DownloadUtils.download((String)url, (String)fileName, (String)bakFilePath);
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileName(fileName);
                    downloadListDetail.setFileLink(fileName);
                    result.add(downloadListDetail);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info("\u5f02\u5e38", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.info("\u4e0b\u8f7d\u94fe\u63a5\u6709\u8bef" + url, (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).paramsMap(new HashMap()).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QLB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-qlb-dc", (Object[])new Object[0]);
    }
}

