/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qlb.dc.service.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.qlb.dc.service.QLBDCCommConfig;
import kd.ebg.receipt.banks.qlb.dc.service.SignUtil;
import kd.ebg.receipt.banks.qlb.dc.service.api.QlbUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Element;

public class FetchTodayBankReceiptListImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private String TFTPRTMHD;

    public List<Map<String, Object>> process(BankReceiptRequest request) {
        BankReceiptResponseEB response;
        this.TFTPRTMHD = "1";
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(8);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getData())) continue;
            retList.addAll((List)response.getData());
        }
        this.TFTPRTMHD = "2";
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getData())) continue;
            retList.addAll((List)response.getData());
        }
        return retList;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        QLBDCCommConfig config = (QLBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(QLBDCCommConfig.class, bankLoginID);
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String turnPageFlag = paramsMap.getOrDefault("turnPageFlag", "1");
        String inStartKey = paramsMap.getOrDefault("in_start_key", "");
        String inEndKey = paramsMap.getOrDefault("in_end_key", "");
        Element root = JDomExtUtils.createRoot((String)"QLBankData");
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE013");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)config.getCstNo());
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"tftprtmhd", (String)this.TFTPRTMHD);
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageFlag", (String)turnPageFlag);
        JDomUtils.addChild((Element)ReqParam, (String)"in_start_key", (String)inStartKey);
        JDomUtils.addChild((Element)ReqParam, (String)"in_end_key", (String)inEndKey);
        SignUtil signUtil = new SignUtil();
        String reqStr = JDomUtils.root2String((Element)root, (String)"GBK");
        bankReceiptRequest.setRequestStr(reqStr);
        BankReceiptResponseEB signResp = signUtil.doBiz(bankReceiptRequest);
        String signStr = (String)signResp.getData();
        return "CBE013|#" + signStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        this.setLastPage(true);
        String retCode = s.split("\\|")[0];
        if (!"0000".equalsIgnoreCase(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s \u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"FetchTodayBankReceiptListImpl_0", (String)"ebg-receipt-banks-qlb-dc", (Object[])new Object[0]), retCode, s.split("\\|")[1]));
        }
        s = QlbUtil.parseMessage(s);
        Element root = JDomUtils.string2Root((String)s, (String)"GBK");
        Element opRep = JDomUtils.getUnNullChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getUnNullChildElement((Element)opRep, (String)"opResult");
        String out_no_data = JDomUtils.getUnNullChildText((Element)opResult, (String)"out_no_data");
        String out_start_key = JDomUtils.getUnNullChildText((Element)opResult, (String)"out_start_key");
        String out_end_key = JDomUtils.getUnNullChildText((Element)opResult, (String)"out_end_key");
        HashMap<String, String> nextPageMap = new HashMap<String, String>(4);
        nextPageMap.put("turnPageFlag", "2");
        nextPageMap.put("in_start_key", out_start_key);
        nextPageMap.put("in_end_key", out_end_key);
        Element list = JDomExtUtils.getUnNullChildElement((Element)opResult, (String)"list");
        List rows = JDomExtUtils.getChildrenElement((Element)list, (String)"row");
        ArrayList all = new ArrayList(8);
        rows.forEach(e -> {
            HashMap<String, String> map = new HashMap<String, String>();
            String tranDate = JDomUtils.getUnNullChildText((Element)e, (String)"tranDate");
            String transferFlowNo = JDomUtils.getUnNullChildText((Element)e, (String)"transferFlowNo");
            String transferSum = JDomUtils.getUnNullChildText((Element)e, (String)"transferSum");
            String tftprtmhd = JDomUtils.getUnNullChildText((Element)e, (String)"tftprtmhd");
            String cmchannelType = JDomUtils.getUnNullChildText((Element)e, (String)"cmchannelType");
            String busnType = JDomUtils.getUnNullChildText((Element)e, (String)"busnType");
            map.put("tranDate", tranDate);
            map.put("transferFlowNo", transferFlowNo);
            map.put("transferSum", transferSum);
            map.put("tftprtmhd", tftprtmhd);
            map.put("cmchannelType", cmchannelType);
            map.put("busnType", busnType);
            all.add(map);
        });
        if ("0".equalsIgnoreCase(out_no_data)) {
            this.setLastPage(false);
            bankReceiptRequest.setParamsMap(nextPageMap);
        }
        return BankReceiptResponseEB.success(all);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE013";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIQLReqServlet");
    }
}

